<?php
defined('_JEXEC') or die('Restricted access');
/*
Plesk Spamdyke Control Panel (Version see version.php) - GUI for Plesk spamdyke implementation

Copyright (C) [2008] [Matthias Hackbarth / www.haggybear.de]

This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as 
published by the Free Software Foundation; either version 3 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty 
of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program; if not, see <http://www.gnu.org/licenses/>.
*/
 

$mod_dir = dirname( __FILE__ );
require("class.showdata.php");

/* Get module parameters */
$plesk_url = $params->get( 'plesk_url', '' );
$plesk_login = $params->get( 'plesk_login', '' );
$plesk_pass = $params->get( 'plesk_pass', '' );
$domain_token = $params->get( 'domain_token', '' );
$per_page = $params->get( 'per_page', '0' );
$spamdyke_path = $params->get( 'glm_path', '' );
$akt_interval = $params->get( 'akt_interval', '15' );

$class_sfx = $params->get( 'class_sfx', '' ); 
$class_mainlevel = "mainlevel".$class_sfx;
$pretext = $params->get( 'pretext', '' ); 

$glm = new showdata($plesk_url,$plesk_login,$plesk_pass,$domain_token,$spamdyke_path,$per_page,$akt_interval);
$glm->show();
?>

<?php if(empty($glm->glmObject->error)):?>
<table width="100%" border="0" cellspacing="0" cellpadding="1" style="font-size:9px">
  <tr> 
    <td width="55%" valign="middle"><?php echo $glm->glmObject->statistik[0]->name;?></td>
    <td width="30%" valign="middle"><div style="margin:0px;padding:0px;background:#CCCCCC;border:1px outset #000000;width:50px;height:10px;"></div></td>
    <td width="15%" valign="middle" align="right"><?php echo $glm->glmObject->statistik[0]->value;?></td>
  </tr>
  <tr> 
    <td width="55%" valign="middle"><?php echo $glm->glmObject->statistik[2]->name;?></td>
    <td width="30%" valign="middle"><div style="margin:0px;padding:0px;background:#009900;border:1px outset #000000;width:<?php echo round(($glm->makeProz($glm->glmObject->statistik[0]->value,$glm->glmObject->statistik[2]->value,0)*0.5),0);?>px;height:10px;"></div></td>
    <td width="15%" valign="middle" align="right"><?php echo $glm->glmObject->statistik[2]->value;?></td>
  </tr>
  <tr> 
    <td width="55%" valign="middle"><?php echo $glm->glmObject->statistik[1]->name;?></td>
    <td width="30%" valign="middle"><div style="margin:0px;padding:0px;background:#FF0000;border:1px outset #000000;width:<?php echo round(($glm->makeProz($glm->glmObject->statistik[0]->value,$glm->glmObject->statistik[1]->value,0)*0.5),0);?>px;height:10px;"></div></td>
    <td width="15%" valign="middle" align="right"><?php echo $glm->glmObject->statistik[1]->value;?></td>
  </tr>   
  <tr style="font-weight:bold"> 
    <td width="55%" valign="middle"><?php echo $glm->glmObject->statistik[3]->name;?></td>
    <td width="45%" colspan="2" valign="middle" align="left"><?php echo $glm->glmObject->statistik[3]->value;?> %</td>
  </tr>   
  <tr> 
    <td colspan="3" height="1" bgcolor="#CCCCCC"></td>
  </tr>
  <tr> 
    <td style="font-size:8px" colspan="3">Version: <?php echo $glm->glmObject->version;?> | Datum: <?php echo date("d.m.Y",(int)$glm->glmObject->datum);?></td>
  </tr>
</table>
<?php else:?>
<div style="color:#FF0000;margin:5px;font-size:14px">
Fehler: <?php echo $glm->glmObject->error;?><br>
Version: <?php echo $glm->glmObject->version;?>
<?php $glm->erase();?>
</div>
<?php endif;?>