<?php	
/*
Plesk Greylisting Manager (Version see version.php) - GUI for Plesk greylisting implementation by Parallels

Copyright (C) [2009] [Matthias Hackbarth / www.haggybear.de]

This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as 
published by the Free Software Foundation; either version 3 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty 
of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program; if not, see <http://www.gnu.org/licenses/>.
*/
require("./paa.class.php");
require("./xtea.class.php");

class glm extends paa{


      var $versionUrl = "http://www.haggybear.de/download/glm2";

      var $glmSettings = array();

      var $allPages = array("domain"=>"./main.php","overview"=>"./main.php","list"=>"./lists.php","plist"=>"./plists.php","admin"=>"./admin.php","update"=>"update.php");
      
      var $viewPage;
      
      var $domainId;

      var $queryString;      

      var $blockedCount = 0;

      var $passedCount = 0;

      var $prozentualValue = "0,00";

      var $mailQueue = array();
      
      var $allLists = array();

      var $allDoms;

      var $suchmuster = false;
      
      var $xtea;
      
      var $mailnames;
      
      var $mailaliases;
      
      var $userlists = array();
      
      var $userlistsCount;
      
      var $ul_status;
      
         function __construct($sess,$getVars,$db){
         	 parent::paa($sess,@$getVars["dom_name"],$db);
   		 parent::openDatabase();
   		 parent::setPleskSkin();
   		 parent::setPleskAllowed();
   		 parent::setPleskSmtpType();
   		 $this->domainId = @$getVars["dom_id"];
   		 if(PSA_VERSION >= 10){
   		    $this->domainId = (PSA_VERSION >= 12)?@$_SESSION["subscription"]["currentId"]:@$_SESSION["subscriptionId"]->current;
   		    $this->psa10_domainGrab();   
   	 	    }
   		 parent::setPleskAllowedDomains($getVars["cl_id"]);
   		 parent::setOnlyAdm(false);
                 $this->allDoms = $this->getAllDomainsAndAliases();
  		 $this->xtea = new XTEA(CRYPT_KEY);
   		 $this->getMailnames();
   		 $this->setPsaIntegration();
         	}

        function __destruct(){
                 parent::closeDatabase();
                 }
 
        function setViewPage($vp){
                 $this->viewPage = (empty($vp))?"domain":$vp;
                 }

        function showDoms($zeit){
                 $retVal = MAILS_ALL;
                 if($this->viewPage == "domain") $retVal = implode(",",$this->allDoms); 
                 return $retVal.' [<a href="#" onClick="getPageContent(\'stat.php?zeit='.$zeit.'&overview='.$this->viewPage.'&'.$this->queryString.'\',\''.SERVER_STAT.'\',\'stat\')">'.SERVER_STAT.'</a>] - [<a href="javascript:doExport()">'.CSV_EXPORT.'</a>]';
                 }		
		 
	function getMailnames(){
		 $sql = "SELECT a.mail_name, b.alias,c.name FROM mail as a LEFT JOIN mail_aliases as b ON (a.id = b.mn_id) RIGHT JOIN domains AS c ON (c.id = a.dom_id) where a.dom_id='".$this->domainId."'";
                 $res = @mysqli_query($this->plesk_db_conn,$sql);
                 while($data = mysqli_fetch_object($res)){
                       $this->mailnames[] = $data->mail_name;
                       if(!empty($data->alias))$this->mailaliases[] = $data->alias.'@'.$data->name;
		       }
		 }
	      function setUserLists(){
	      	
	      	
	      	       $mbox = (isset($_POST["mboxFull"]))?$_POST["mboxFull"]:@$_POST["mbox"].'@'.$this->allDoms[0];
	      	       $ret="";
	      	       
	               if($_POST["addwl"] && !empty($_POST["entry"])){
	      	       	 $ret = 'error|<span class="block">'.ERR_PLISTS.'</span>|'.UPDATE_GLM_NOK;
	      	       	 if(stristr($_POST["entry"],"@")){
	      	       	    $out = shell_exec('/usr/local/psa/bin/grey_listing -um '.$mbox.' -whitelist add:'.$_POST["entry"].' 1> dbs/'.$mbox.'.erg');
	      	       	    if(!empty($out)) file_put_contents('dbs/'.$mbox.'.erg',$out);
	      	       	    $out = file_get_contents('dbs/'.$mbox.'.erg');
	      	       	    unlink('dbs/'.$mbox.'.erg');
                            $ret = 'info|<span class="pass">'.sprintf(P_WHITELISTS_NOTICE_ENTRY,$_POST["entry"],$mbox).'</span>|'.UPDATE_GLM_OK;
	      	       	    }
	      	       	  }
	      	       if($_POST["addbl"] && !empty($_POST["entry"])){
        	       	 $ret = 'error|<span class="block">'.ERR_PLISTS.'</span>|'.UPDATE_GLM_NOK;
 	      	         if(stristr($_POST["entry"],"@")){
	      	       	    $out = shell_exec('/usr/local/psa/bin/grey_listing -um '.$mbox.' -blacklist add:'.$_POST["entry"].' &> dbs/'.$mbox.'.erg');
	      	       	    if(!empty($out)) file_put_contents('dbs/'.$mbox.'.erg',$out);
	      	       	    $out = file_get_contents('dbs/'.$mbox.'.erg');
	      	       	    unlink('dbs/'.$mbox.'.erg');
	      	       	    $ret = 'info|<span class="pass">'.sprintf(P_BLACKLISTS_NOTICE_ENTRY,$_POST["entry"],$mbox).'</span>'.'|'.UPDATE_GLM_OK;
	      	       	    }
	      	       	 }

	      	       if(!empty($_GET["delwl"])){
	      	       	  exec('/usr/local/psa/bin/grey_listing -um '.$_GET["mbox"].'@'.$this->allDoms[0].' -whitelist del:'.str_replace(" ","+",urldecode($_GET["delwl"])));
	      	       	  $out = "SUCCESS";
	      	       	  }
	      	       if(!empty($_GET["delbl"])){
	      	       	  exec('/usr/local/psa/bin/grey_listing -um '.$_GET["mbox"].'@'.$this->allDoms[0].' -blacklist del:'.str_replace(" ","+",urldecode($_GET["delbl"])));
	      	       	  $out = "SUCCESS";
	      	       	  }
	      	       	  
	      	       if(!stristr($out,"SUCCESS")){
	      	       	  echo 'error|<span class="block">ERROR:'.$out.'</span>|'.UPDATE_GLM_NOK;
	      	       	  return;
	      	       	  }
	      	       	      	       	  
	      	       $this->getUserLists();	  
	      	       echo $ret;
	      	       }
		 
	function getUserLists(){
		$this->userlistsCount = array("white"=>0,"black"=>0);
		$this->userlists = NULL;
		$res = @mysqli_query($this->plesk_db_conn,'SELECT a.preference,a.value,b.username FROM spamfilter_preferences as a, spamfilter as b where a.spamfilter_id = b.id and a.preference like "%_from"');
		while($data = mysqli_fetch_object($res)){
			$collect = str_replace("list_from","",$data->preference);
			$out = substr($data->username,0,strpos($data->username,"@"));
			$this->userlists[$out][$collect][] = $data->value;
			}
		$_SESSION["ministats"]["userLists"] = $this->userlistsCount["white"].'/'.$this->userlistsCount["black"];
		}

	
	function greylistingProps($data){

                  $w = "";
                  if($this->viewPage == "domain"){
                     $w = "AND (rcptTo LIKE '%@".implode("' or rcptTo LIKE '%@",$this->allDoms)."')";
                     }
		  $dbh = new PDO('sqlite:'.DB_FILE_DATA);
		  $dates = array();
		  $_SESSION["glDates"] = array();
		  
                  foreach ($dbh->query("SELECT * FROM data ".str_replace("AND","WHERE",$w)." order by lastUpdate desc") as $row){
                   	  if(!$row["passCount"])$this->blockedCount+=($row["blockedCount"]+1);
                          $this->passedCount+=$row["passCount"];
			  $fDate = strtotime(date("d F Y",$row["lastUpdate"]));
			  if(!in_array($fDate ,$_SESSION["glDates"])) $_SESSION["glDates"][] = $fDate;
                          }
                  rsort($_SESSION["glDates"]);
                  
                  $w2 = "";
                  $s = "";
			  
                  if(@$data["filter"]=="pass") $w2.=" AND passCount>0";
                  if(@$data["filter"]=="block") $w2.=" AND passCount=0";
                  if(@$data["filter"]=="all") $w2 ="";

                  if($this->suchmuster){
                     $s.= " AND (remoteIP like '%".$this->suchmuster."%' or  mailFrom like '%".$this->suchmuster."%' or rcptTo like '%".$this->suchmuster."%')";
                     }

		  if(empty($_POST["zeit"])) $_POST["zeit"] = $_SESSION["glDates"][0];

		  if($_POST["zeit"] != "all"){
                     $myQry = "SELECT * FROM data WHERE (lastUpdate >= ".$_POST["zeit"]." and lastUpdate < ".($_POST["zeit"]+86400).") $w $w2 $s order by lastUpdate desc"; 
		     }
                  else{
		     $myQry = str_replace("AND","WHERE","SELECT * FROM data $w $w2 $s order by lastUpdate desc"); 
		  }

                  foreach ($dbh->query($myQry) as $row){
                  	   $this->mailQueue[] = $row;
                           }

                 $ps = $this->blockedCount / ($this->blockedCount+$this->passedCount) * 100;
	         $this->prozentualValue = str_replace(".",",",round($ps,2));
	         $this->greylistingList();
                 }


        function greylistingUpdate($data,$what){
                  while (list($key, $val) = each($data)) {
                      if(stristr($key,"kide_blfr_")){
                         $pair = explode("#",$val);
                         if($what=="pass"){
                            $sql="UPDATE data set passCount=passCount+1 where creationTime='".$pair[0]."' and remoteIP='".$pair[1]."'";
                         }
                         else if ($what=="block"){
                            $sql="UPDATE data set passCount=0 where creationTime='".$pair[0]."' and remoteIP='".$pair[1]."'";
                         }
			 else if ($what=="kill"){
                            $sql="DELETE from data where creationTime='".$pair[0]."' and remoteIP='".$pair[1]."'";
                         }
			 else{
                         return;
                         }
                         //file_put_contents('d.txt','./sh/wrapper "1" "'.DB_FILE_DATA.'" "'.$sql.'"');
                         shell_exec('./sh/wrapper "1" "'.DB_FILE_DATA.'" "'.$sql.'"');
                         //file_put_contents('d.txt', $out, FILE_APPEND);
                         }
                     }
                 }
                 
        function readAbuseSettings(){
                 $file = fopen("dbs/abuse.txt",'r');
                 $this->glmSettings["abuse"] = unserialize(trim(fread($file,filesize("dbs/abuse.txt"))));
                 fclose($file);
                 }
                 
        function readRemoteSettings(){
                 $file = fopen("dbs/remote.txt",'r');
                 $this->glmSettings["remote"] = unserialize(trim(fread($file,filesize("dbs/remote.txt"))));
                 fclose($file);
                 }
                 
     function setPsaIntegration(){
                 $res = mysqli_query($this->plesk_db_conn,"SELECT id FROM custom_buttons WHERE text = 'Greylisting Administration'");
                 $this->glmSettings["psaIntegration"] = (mysqli_num_rows($res)>0)?"true":"false";
                 }

        function schreibeAbuseSettings(){
                 $write = serialize($this->glmSettings["abuse"]);
                 $openStream = fopen ("dbs/abuse.txt","w");
                 fwrite($openStream,$write,strlen($write)); 
                 fclose($openStream);
                 }
                 
        function schreibeRemoteSettings(){
                 $write = serialize($this->glmSettings["remote"]);
                 $openStream = fopen ("dbs/remote.txt","w");
                 fwrite($openStream,$write,strlen($write)); 
                 fclose($openStream);
                 }

        function greylistingUpdateAdm($what){
                 if($what=="killall"){
                    $sql="DELETE FROM data";
                    }
                 else if($what=="cleanup"){
                    $delTs = (time() - ($this->glmSettings["expireInterval"]*60));
                    $sql="DELETE FROM data creationTime<'".$delTs."'";
                    }
                 else{
                   return;
                   }

                 exec('sh/wrapper "1" "'.DB_FILE_DATA.'" "'.$sql.'"');
                 }

        function greylistingList(){
                 if(PSA_VERSION < 11){
		    $sql = "SELECT * from GL_remote_domains";
                    $res = @mysqli_query($this->plesk_db_conn,$sql);
                    while($data = mysqli_fetch_object($res)){
                        $this->allLists[$data->type][] = $data->domain;
		        }
		    }
                 else{
                    exec('/usr/local/psa/bin/grey_listing --info-server ',$out);
		    $type = "";
            	    for($i=0;$i<count($out);$i++){
                        if(stristr($out[$i],"Server-wide black") || stristr($out[$i],"Black domains patterns")){ $type = "black"; continue;}
                        if(stristr($out[$i],"Server-wide white") || stristr($out[$i],"White domains patterns")){ $type = "white"; continue;}
		        if(!empty($type)){
                    	    if(!empty($out[$i])){
                        	$this->allLists[$type][] = $out[$i];
                        	}
                    	    else{
                        	$type = "";
                    		}
                    	    }
                        }
		      }
                    }


        function getGreylistingTableJson(){
        	       $jsonErg["rows"] = array();
        	       $jsonErg["total"] = count($this->mailQueue);
        	       $i=0;
        	       while($i<$jsonErg["total"]){
        	       	   $i++;
        	       	   if($i > ($_POST["rows"]*$_POST["page"]) ||
	                      $i <= ($_POST["rows"]*($_POST["page"]-1))) continue;
	                   $cells[] = array("fromIp" => $this->mailQueue[$i-1]["remoteIP"],
	                                    "fromMail" => $this->mailQueue[$i-1]["mailFrom"],
	                                    "toMail" => $this->mailQueue[$i-1]["rcptTo"],
	                                    "blocked" => $this->mailQueue[$i-1]["blockedCount"]+1,
	                                    "passed" => $this->mailQueue[$i-1]["passCount"],
	                                    "created" => $this->mailQueue[$i-1]["creationTime"],
	                                    "update" => $this->mailQueue[$i-1]["lastUpdate"],
	                                    "expires" => $this->mailQueue[$i-1]["greyExpires"]);
        	       	   }
        	       $jsonErg["rows"] = $cells;
        	       echo json_encode($jsonErg);
        	       }
         

          function doExport(){
      	        $count = count($this->mailQueue);
      	        $sendStr = "";
      	        $sendStr = FROM_IP.",".FROM_MAIL.",".TO_MAIL.",".BLOCKED.",".PASSED.",".ENTRY_AT.",".LAST_UPDATE.",".str_replace("&auml;","ae",EXPIRES)."\n";
                for($i=0;$i<$count;$i++){
                    $sendStr.=strip_tags($this->mailQueue[$i]["remoteIP"]).",";
                    $sendStr.=strip_tags($this->mailQueue[$i]["mailFrom"]).",";
                    $sendStr.=strip_tags($this->mailQueue[$i]["rcptTo"]).",";
                    $sendStr.=strip_tags($this->mailQueue[$i]["blockedCount"]+1).",";
                    $sendStr.=strip_tags($this->mailQueue[$i]["passCount"]).",";
                    $sendStr.=date(TIME_SCHEME,$this->mailQueue[$i]["creationTime"]).",";
                    $sendStr.=date(TIME_SCHEME,$this->mailQueue[$i]["lastUpdate"]).",";
		    $sendStr.=date(TIME_SCHEME,$this->mailQueue[$i]["greyExpires"])."\n";
                    }  
               header ("Content-type: application/excel");
               header ("Content-Disposition: download; filename=GLM-export".date("d-m-y_H:i:s").".csv"); 
               echo $sendStr;
               exit;
      	       } 


	  function highlight($str){
                   if(!$this->suchmuster) return $str;

                   return str_replace($this->suchmuster,"<span class=\"highlight\">".$this->suchmuster."</span>",$str);
                   }
 
        function checkGLMPermissions(){

                 $sql = "SELECT * from GL_settings";
                 $res = @mysqli_query($this->plesk_db_conn,$sql);
                 while($data = mysqli_fetch_object($res)){
                      $this->glmSettings[$data->param] = $data->value;
		      }
                 if(!count($this->glmSettings)){
                    return '<br><div class="block">'.GLM_NO_GREYLISTING_SUPPORT.'</div><br>';
                   }
                 if(!$this->glmSettings["enabled"]){
                    return '<br><div class="block">'.GLM_GREYLISTING_NO_ACTIVE.'</div><br>';
                   }
                 return false;

                 }

      function saveAdmin($data){
               while (list($key, $val) = each($data)) {
                      if(stristr($key,"adm_")){
                         $param = str_replace("adm_","",$key);
                         $value = $val;
                         $query = "UPDATE %s set value ='%s' where param ='%s'";
                         $qryMysql  = sprintf($query,'GL_settings',$value,$param); 
                         $qrySqlite = sprintf($query,'settings',(is_numeric($value))?($value*60):$value,$param);                      
                         exec('sh/wrapper "1" "'.DB_FILE_SETTINGS.'" "'.$qrySqlite.'"');
                         @mysqli_query($this->plesk_db_conn,$qryMysql);
                         }
                      if(stristr($key,"psaIntegration")&&$this->glmSettings["psaIntegration"]!=$val){
                         
                	 $type = ($val==="true")?"add":"del";
                         $folder = str_replace("/json.php","",$_SERVER["SCRIPT_NAME"]);
                         $sql["add"] = "INSERT INTO custom_buttons(level,level_id,place,text,url,conhelp,options,file,plan_item_name) VALUES (1,0,'navigation','Greylisting Administration','".$folder."/index.php?cl_id=0','Greylisting Administration','256','../..".$folder."/images/glmlogo.gif',NULL)";
                         $sql["del"] = "DELETE FROM custom_buttons WHERE text = 'Greylisting Administration'";
                         mysqli_query($this->plesk_db_conn,$sql[$type]);
                         $this->glmSettings["psaIntegration"] = $val;
                         }
                     }  
		     
               $this->glmSettings["abuse"] = $data["spam-abuse"];
               if($this->glmSettings["remote"]["enabled"] != $data["remote-access"]["enabled"]){
	          $this->glmSettings["remote"]["enabled"] = $data["remote-access"]["enabled"];
		  }
	       
	       if($this->glmSettings["remote"]["admin"] != $data["remote-access"]["admin"]){
	       
	          if($data["remote-access"]["admin"] == "true"){
		     $this->glmSettings["remote"]["supertoken"] = $this->xtea->Encrypt(rand(1111111,9999999));
		     }
		  else{
		     unset($this->glmSettings["remote"]["supertoken"]);
		    }
	       
	          $this->glmSettings["remote"]["admin"] = $data["remote-access"]["admin"];
		  }
	       
               $this->schreibeAbuseSettings();
               $this->schreibeRemoteSettings();
               $this->checkGLMPermissions();
               }

      function checkVersion($v){
		$url = $this->versionUrl.".txt";
 	   	$p = fopen($url,"r");
	 	$ver  = fgets($p,16);
	 	fclose($p);

		if($this->plesk_session->chkLevel(IS_ADMIN) && AUTOUPDATE){
	           if($v != $ver){ 
 		      echo "<a href=\"#\" id=\"updateCheck\">".str_replace("{VER}",$ver,GLM_VERSION_UPD)."</a>";
		      return;
		      }
	        }
	     
	 	if($v != $ver){
		   echo "<a href=\"".$this->versionUrl.".zip\">".str_replace("{VER}",$ver,GLM_VERSION_NOK)."</a>";
		   return;
		   }
	 
	 	echo GLM_VERSION_OK;
        	}

     function setQueryString($qs){
            	$expr = '/statmessage=(.*)&/i';
		$qs = preg_replace($expr, '', $qs);
		$expr = '/&todo=(.*)/i';
		$qs = preg_replace($expr, '', $qs);
		$expr = '/&admin=(.*)/i';
		$qs = preg_replace($expr, '', $qs);
                $expr = '/&action=(.*)/i';
		$qs = preg_replace($expr, '', $qs);
        	$this->queryString = $qs;
              }

     function getQueryString(){
              echo $this->queryString;
              }

     function getAllDomainsAndAliases(){
	
	         $doms[] = $this->plesk_domain;



	         $hasDomAlias = NULL;
	       
	         if(mysqli_num_rows(mysqli_query($this->plesk_db_conn,"SHOW TABLES LIKE 'domainaliases'"))>0) $hasDomAlias = "";
           if(mysqli_num_rows(mysqli_query($this->plesk_db_conn,"SHOW TABLES LIKE 'domain_aliases'"))>0) $hasDomAlias = "_";                   
                 $result = mysqli_query($this->plesk_db_conn,"SELECT a.id, a.name, b.id FROM psa.domain".$hasDomAlias."aliases AS a, psa.domains AS b WHERE b.name = '".$this->plesk_domain."' AND b.id = a.dom_id");
                 if($result && $hasDomAlias!=NULL){
                    while($data = mysqli_fetch_object($result)){
                          $doms[] = $data->name;
	                  }
	            }
      //file_put_contents("d.txt",var_export($doms,true));
      return $doms;

	  }
    
     function greylistingListSave($data,$toDelete){
              if(PSA_VERSION < 11){

               if($toDelete){
                  @mysqli_query($this->plesk_db_conn,"DELETE from GL_remote_domains");
                  exec('sh/wrapper "1" "'.DB_FILE_SETTINGS.'" "DELETE from remote_domains"');
                  }
              
               $queryInsert = "INSERT INTO %s (domain,type) VALUES ('%s','%s')";
               $ret="";
 
               while (list($key, $val) = each($data)) {
                       if(stristr($key,"white_") && !empty($val)){
                         
                         if(preg_match("#([0-9]{1,3})\.([0-9]{1,3})\.([0-9]{1,3})\.([0-9]{1,3})#",  $val)){
                            $ip = $val;
                            $val = gethostbyaddr($ip); 
 			                     $ret["w"][$ip] = $val;
                            $ip = null;
                            }

                          $value_mysql = $val;
                          $value_sqllite = str_replace('.', '\.', $val);
                          $value_sqllite = str_replace('*', '.*', $value_sqllite);
                          $qryMysql  = sprintf($queryInsert,'GL_remote_domains',$value_mysql,'white'); 
                          $qrySqlite = sprintf($queryInsert,'remote_domains',$value_sqllite,'white');   
                          exec('sh/wrapper "1" "'.DB_FILE_SETTINGS.'" "'.$qrySqlite.'"');
                          @mysqli_query($this->plesk_db_conn,$qryMysql);
                          }
                       if(stristr($key,"black_") && !empty($val)){

                         if(preg_match("#([0-9]{1,3})\.([0-9]{1,3})\.([0-9]{1,3})\.([0-9]{1,3})#",  $val)){
                            $ip = $val;
                            $val = gethostbyaddr($ip); 
 			                     $ret["b"][$ip] = $val;
                            $ip = null;
                            }

                          $value_mysql = $val;
                          $value_sqllite = str_replace('.', '\.', $val);
                          $value_sqllite = str_replace('*', '.*', $value_sqllite);
                          $qryMysql  = sprintf($queryInsert,'GL_remote_domains',$value_mysql,'black'); 
                          $qrySqlite = sprintf($queryInsert,'remote_domains',$value_sqllite,'black');                      
                          exec('sh/wrapper "1" "'.DB_FILE_SETTINGS.'" "'.$qrySqlite.'"');
                          @mysqli_query($this->plesk_db_conn,$qryMysql);
                          }
                      }
                  }
              else{
                  $l["white"]["mail"] = array();
                  $l["black"]["mail"] = array();
                  $l["black"]["dom"] = array();
                  $l["white"]["dom"] = array();

                  if($toDelete){
                    for($i=0;$i<count($this->allLists["white"]);$i++){
		  	if(stristr($this->allLists["white"][$i],"@")){
                           $l["white"]["mail"][] = trim($this->allLists["white"][$i]);
                           }
                        else{
                           $l["white"]["dom"][] = trim($this->allLists["white"][$i]);
                           }
                        }
                    for($i=0;$i<count($this->allLists["black"]);$i++){
		  	if(stristr($this->allLists["black"][$i],"@")){
                           $l["black"]["mail"][] = trim($this->allLists["black"][$i]);
                           }
                        else{
                           $l["black"]["dom"][] = trim($this->allLists["black"][$i]);
                           }

                        }
	           if(count($l["white"]["mail"])>0) exec('/usr/local/psa/bin/grey_listing --update-server -whitelist del:'.implode(",",$l["white"]["mail"]));
                   if(count($l["black"]["mail"])>0) exec('/usr/local/psa/bin/grey_listing --update-server -blacklist del:'.implode(",",$l["black"]["mail"]));
                   if(count($l["white"]["dom"])>0) exec('/usr/local/psa/bin/grey_listing --update-server -domains-whitelist del:'.implode(",",$l["white"]["dom"]));
                   if(count($l["black"]["dom"])>0) exec('/usr/local/psa/bin/grey_listing --update-server -domains-blacklist del:'.implode(",",$l["black"]["dom"]));


                    }
                  $l["white"]["mail"] = array();
                  $l["black"]["mail"] = array();
                  $l["black"]["dom"] = array();
                  $l["white"]["dom"] = array();

            	  while (list($key, $val) = each($data)) {
                         if(stristr($key,"white_") && !empty($val)){
                            if(stristr($val,"@")){
                               $l["white"]["mail"][] = trim($val);
                               }
                            else{
                               $l["white"]["dom"][] = trim($val);
                              }
                            }

                         if(stristr($key,"black_") && !empty($val)){
                            if(stristr($val,"@")){
                               $l["black"]["mail"][] = trim($val);
                               }
                            else{
                               $l["black"]["dom"][] = trim($val);
                              }
                            }
			 }
	        if(count($l["white"]["mail"])>0) exec('/usr/local/psa/bin/grey_listing --update-server -whitelist add:'.implode(",",$l["white"]["mail"]));
                if(count($l["black"]["mail"])>0) exec('/usr/local/psa/bin/grey_listing --update-server -blacklist add:'.implode(",",$l["black"]["mail"]));
                if(count($l["white"]["dom"])>0) exec('/usr/local/psa/bin/grey_listing --update-server -domains-whitelist add:'.implode(",",$l["white"]["dom"]));
                if(count($l["black"]["dom"])>0) exec('/usr/local/psa/bin/grey_listing --update-server -domains-blacklist add:'.implode(",",$l["black"]["dom"]));
              }

              return $ret;
	      }

     function printAddedListEntries($data){
              if(@count($data["w"])){
                 echo '<br><div class="pass">';
                 while (list($key, $val) = @each($data["w"])) {
                 echo sprintf(WHITELISTS_NOTICE_ENTRY,'<u>'.$key.'</u>','<u>'.$val.'</u>');
                 echo '<br>';
                       }
                 echo '</div>';
                 }

              if(@count($data["b"])){
                 echo '<br><div class="block">';
                 while (list($key, $val) = @each($data["b"])) {
                 echo sprintf(BLACKLISTS_NOTICE_ENTRY,'<u>'.$key.'</u>','<u>'.$val.'</u>');
                 echo '<br>';
                       }
                 echo '</div>';
                 }
             }

              
     function prinStatJson(){
     	        $statData = array();
     	        $jsonData = array();
     	        for($i=0;$i<count($this->mailQueue);$i++){
     	        	 
     	        	  $teil = $this->mailQueue[$i]["rcptTo"]; 
     	        	  if($this->viewPage == "overview"){
     	        	     $props = explode("@",$this->mailQueue[$i]["rcptTo"]);
     	        	     $teil = $props[1];
     	        	     }
     	        	  
     	        	  if($this->mailQueue[$i]["passCount"] == 0){
     	        	  	 @$statData[$teil]+=($this->mailQueue[$i]["blockedCount"]+1);                      
     	        	     } 
     	            } 	
     	         	
     	        while (list($key, $val) = each($statData)) {
                     $jsonData[] = array("label"=>$key,
     	        	  	                     "data"=>$val);
     	          	        	
     	        	     }
     	       	echo json_encode($jsonData); 	  	
     	        }
              
          
      function sendSpamReport($data){

               if(!$this->plesk_session->chkLevel(IS_ADMIN)){
                   echo "NO RIGHTS TO SEND AN ABUSE MAIL!";
                   exit;
                  }

               $spamline = "==============================================\n";
               $spamline.= "FROM: ".$data["from"]."\n";
               $spamline.= "TO: ".$data["to"]."\n";
               $spamline.= "IP: ".$data["ip"]."\n";
               $spamline.= "TIMESTAMP: ".$data["create"]."\n";
               $spamline.= "==============================================";

               $nachricht = str_replace("{SPAMLINE}",$spamline,$this->glmSettings["abuse"]["template"]);
               $header = 'From: '.$this->glmSettings["abuse"]["sender"]. "\r\n";
               $header.= 'Reply-To: '.$this->glmSettings["abuse"]["sender"]. "\r\n";
               $header.= 'Bcc: '.$this->glmSettings["abuse"]["sender"]. "\r\n";
               $header.= 'GLM[haggybear.de]/X-Mailer: PHP/' . phpversion();
               $isSend = mail($data["rec"], $this->glmSettings["abuse"]["titel"], $nachricht, $header);
               if(!$isSend){
                   echo "ERROR WHILE SENDING THE MAIL!";
                   exit;
                   }
               echo "emailwassend";

               }
               
     function checkForRemoteAccess(){
              $edit = (@$this->glmSettings["remote"]["enabled"]=="true")?true:false;
              $select = (@$this->glmSettings["remote"][$this->allDoms[0]])?"selected":"";
                                                                          
              if($edit){
                 $token = (@$this->glmSettings["remote"][$this->allDoms[0]])?"token:".$this->xtea->Decrypt($this->glmSettings["remote"][$this->allDoms[0]]):VALUE_ACT;
                 echo "<select id=\"isremoteaccess\" class=\"easyui-combobox\" panelHeight=\"auto\" style=\"width:100px\">\n";
                 echo "<option value=\"0\">".VALUE_DEACT."</option>\n";
                 echo "<option value=\"1\" ".$select.">".$token."</option>\n";
                 echo "</select>";
                }else{
                 echo VALUE_DEACT;
                }
              }
              
     function RemoteAccess(){
     
              $raid = rand(100000,999999);
                  
              if($_GET["isremoteaccess"]){
                 $this->glmSettings["remote"][$this->allDoms[0]] = $this->xtea->Encrypt($raid);
              }else{
                 unset($this->glmSettings["remote"][$this->allDoms[0]]);
                 }
              $this->schreibeRemoteSettings();
              
              $jsonErg[0]["id"]="0";
              $jsonErg[0]["text"]=VALUE_DEACT;
              if(!$_GET["isremoteaccess"])$jsonErg[0]["selected"]=true;
              $jsonErg[1]["id"]="1";
              $jsonErg[1]["text"]=($_GET["isremoteaccess"])?'token:'.$raid:VALUE_ACT;
              if($_GET["isremoteaccess"])$jsonErg[1]["selected"]=true;
              
              echo json_encode($jsonErg);
              }
}
?>
