<?php
/*
Plesk Greylisting Manager (Version see version.php) - GUI for Plesk greylisting implementation by Parallels

Copyright (C) [2009] [Matthias Hackbarth / www.haggybear.de]

This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as 
published by the Free Software Foundation; either version 3 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty 
of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program; if not, see <http://www.gnu.org/licenses/>.
*/
if(function_exists("apc_clear_cache")) @apc_clear_cache();
@session_start();
include("./config.inc.php");
include("./version.php");
include("./lang/".LANG.".inc.php");
include("./glm.class.php");

$glm = new glm(@$session,@$_GET,array(DB_HOST,DB_NAME,DB_USR,DB_PWD));	
$glm->setViewpage(@$_GET["action"]);

if($glm->viewPage == "abusemail"){
   $glm->readAbuseSettings();	
   $glm->sendSpamReport($_POST);
   exit;
   } 

if(isset($_POST["query"]))$glm->suchmuster = $_POST["query"];
if(isset($_POST["but_pass"])) $glm->greylistingUpdate($_POST,"pass");
if(isset($_POST["but_block"])) $glm->greylistingUpdate($_POST,"block");
if(isset($_POST["but_kill"])) $glm->greylistingUpdate($_POST,"kill");

if(isset($_POST["but_killall"]) && $glm->plesk_session->chkLevel(IS_ADMIN)) $glm->greylistingUpdateAdm("killall");
if(isset($_POST["but_cleanup"]) && $glm->plesk_session->chkLevel(IS_ADMIN)) $glm->greylistingUpdateAdm("cleanup");

if($_GET["type"] == "listentries"){
   $glm->greylistingProps($_POST);
   $glm->getGreylistingTableJson();
   $_SESSION["ministats"]["blockedCount"] = $glm->blockedCount;
   $_SESSION["ministats"]["passedCount"] = $glm->passedCount;
   $_SESSION["ministats"]["allLists"] = count(@$glm->allLists["white"]).'/'.count(@$glm->allLists["black"]);
   $_SESSION["ministats"]["prozentualValue"] = $glm->prozentualValue.' %';
   }
   
if($_GET["type"] == "lists"){
   $glm->greylistingList();
   
   $jsonErg[0]["id"] = "wl";
   $jsonErg[0]["text"] = "<b>".EXIST_WHILTELIST."</b>";
   $jsonErg[0]["iconCls"] = "icon-list-white";
   $jsonErg[0]["state"] = "open";
   $jsonErg[1]["id"] = "bl";
   $jsonErg[1]["text"] = "<b>".EXIST_BLACKLIST."</b>";;
   $jsonErg[1]["iconCls"] = "icon-list-black";
   $jsonErg[1]["state"] = "open";   
   
   $whitelists = array();
   for($i=0;$i<@count($glm->allLists["white"]);$i++){
      $whitelists[] = array("id"=>"white_".$i,"text"=>$glm->allLists["white"][$i],"iconCls"=>"icon-list-white","checked"=>true);
      } 
   $jsonErg[0]["children"] = $whitelists;        


   $blacklists = array();
   for($i=0;$i<@count($glm->allLists["black"]);$i++){
      $blacklists[] = array("id"=>"black_".$i,"text"=>$glm->allLists["black"][$i],"iconCls"=>"icon-list-black","checked"=>true);
      }
      
   $jsonErg[1]["children"] = $blacklists;   
   
   echo json_encode($jsonErg);
} 

if($_GET["type"] == "deletelists"){  
   $glm->greylistingList();  
   $_SESSION["ministats"]["allLists"] = count($glm->allLists["white"]).'/'.count($glm->allLists["black"]);  	
   $glm->greylistingListSave($_POST,true);
   }
   
if($_GET["type"] == "newlists"){  
   $res = $glm->greylistingListSave($_POST,false);
   if(@count($res["w"])==0 && @count($res["b"])==0){
   	 echo "noinfo";
   	 exit;
     }
   $glm->greylistingList();  
   $_SESSION["ministats"]["allLists"] = count($glm->allLists["white"]).'/'.count($glm->allLists["black"]);  
   $glm->printAddedListEntries($res);
   }

if($_GET["type"] == "lists-pers"){
   $glm->getUserLists();
   for($i=0;$i<count($glm->mailnames);$i++){
   	   $jsonErg[$i]["id"] = "mail_".$glm->mailnames[$i];
       $jsonErg[$i]["text"] = "<b>".$glm->mailnames[$i].'@'.implode(" / ",$glm->allDoms)."</b>";
       $jsonErg[$i]["iconCls"] = "icon-domain";
       $jsonErg[$i]["state"] = "open";
       
       $jsonErg[$i]["children"][0]["id"] = "wl_".$glm->mailnames[$i];
       $jsonErg[$i]["children"][0]["text"] = "<b>".EXIST_WHILTELIST."</b>";
       $jsonErg[$i]["children"][0]["iconCls"] = "icon-list-white-pers";
       $jsonErg[$i]["children"][0]["state"] = "open";
       for($ii=0;$ii<@count($glm->userlists[$glm->mailnames[$i]]["white"]);$ii++){
       	   $jsonErg[$i]["children"][0]["children"][$ii]["id"] = "wl:".$glm->mailnames[$i].":".$ii;
       	   $jsonErg[$i]["children"][0]["children"][$ii]["text"] = $glm->userlists[$glm->mailnames[$i]]["white"][$ii];
       	   $jsonErg[$i]["children"][0]["children"][$ii]["iconCls"] = "icon-list-white";
       	   $jsonErg[$i]["children"][0]["children"][$ii]["checked"] = false;
       	   }
       
       $jsonErg[$i]["children"][1]["id"] = "bl_".$glm->mailnames[$i];
       $jsonErg[$i]["children"][1]["text"] = "<b>".EXIST_BLACKLIST."</b>";;
       $jsonErg[$i]["children"][1]["iconCls"] = "icon-list-black-pers";
       $jsonErg[$i]["children"][1]["state"] = "open"; 
        for($ii=0;$ii<@count($glm->userlists[$glm->mailnames[$i]]["black"]);$ii++){
       	   $jsonErg[$i]["children"][1]["children"][$ii]["id"] = "bl:".$glm->mailnames[$i].":".$ii;
       	   $jsonErg[$i]["children"][1]["children"][$ii]["text"] = $glm->userlists[$glm->mailnames[$i]]["black"][$ii];
       	   $jsonErg[$i]["children"][1]["children"][$ii]["iconCls"] = "icon-list-black";
       	   $jsonErg[$i]["children"][1]["children"][$ii]["checked"] = false;
       	   }      
   	   }
   
   echo json_encode($jsonErg);
} 

if($_GET["type"] == "deletelists-pers"){  

   while(list($key, $val) = each($_POST)) {
          if(stristr($key,"wl:")){
          	$details = explode(":",$key);
          	$_GET["delwl"] = str_replace("--DOT--",".",trim($val));
          	$_GET["mbox"] = str_replace("--DOT--",".",trim($details[1]));
          	}
          if(stristr($key,"bl:")){
          	$details = explode(":",$key);
          	$_GET["delbl"] = str_replace("--DOT--",".",trim($val));
          	$_GET["mbox"] = str_replace("--DOT--",".",trim($details[1]));
          	}
        $glm->setUserLists();
        }
   }
if($_GET["type"] == "newlists-pers"){  
   $glm->setUserLists();
   }   

if($_GET["type"] == "admsave" && $glm->plesk_session->chkLevel(IS_ADMIN)){ 
   $glm->readAbuseSettings();
   $glm->readRemoteSettings();
   $glm->saveAdmin($_POST);
   echo trim(@$glm->xtea->Decrypt($glm->glmSettings["remote"]["supertoken"]))."|TOKEN";
   }    

if($_GET["type"] == "remoteaccess"){
	 $glm->readRemoteSettings();
	 $glm->RemoteAccess();
	 }

?>

