<?php
/*
Plesk Greylisting Manager (Version see version.php) - GUI for Plesk greylisting implementation by Parallels

Copyright (C) [2009] [Matthias Hackbarth / www.haggybear.de]

This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as 
published by the Free Software Foundation; either version 3 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty 
of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program; if not, see <http://www.gnu.org/licenses/>.
*/

apc_clear_cache();


include("./config.inc.php");
include("./version.php");
include("./lang/".LANG.".inc.php");
include("./glm.class.php");

$xtea = new XTEA(CRYPT_KEY);

$file = fopen("dbs/remote.txt",'r');
$remoteStates = unserialize(trim(fread($file,filesize("dbs/remote.txt"))));
fclose($file);
$do = false;
$vp = "";

if(!empty($_COOKIE["TOKEN"])){

if(strlen(trim($_COOKIE["TOKEN"]))==6 && $remoteStates["admin"]=="true"){
   while(list($key,$val) = each($remoteStates)){
         if(trim($_COOKIE["TOKEN"]) == trim($xtea->Decrypt($val))){
            $do = true;
	    $vp = "domain";
            $_GET["dom_name"] = $key;
            }
         }
   }
   
if(strlen(trim($_COOKIE["TOKEN"]))==7 && $remoteStates["admin"]=="true"){
   if(trim($_COOKIE["TOKEN"]) == trim($xtea->Decrypt($remoteStates["supertoken"]))){
      $do = true;
      $vp = "overview";
      }
   }    
   
	 

}
      
if(!$do){
   die("<glm>\n <version>".GLM_VERSION."</version>\n <error>Invalid token!</error>\n</glm>");	
   }
   
if(isset($_GET["perPage"])) $_POST["limit"] = $_GET["perPage"];
   
if(!$_POST["limit"]) $_POST["limit"] = "50";
if(!$_POST["filter"]) $_POST["filter"] = "all";

$glm = new glm($session,$_GET,array(DB_HOST,DB_NAME,DB_USR,DB_PWD));
$glm->greylistingProps($_POST);	
$glm->setViewPage($vp);

$xml ="<?xml version=\"1.0\"?>\n";
$xml.="<glm>\n";
$xml.=" <version>".GLM_VERSION."</version>\n";
$xml.=" <entrys>".$_POST["limit"]."</entrys>\n";
$xml.=" <datum>".$glm->glDates[0]."</datum>\n";
$xml.=" <statistik>\n";
$xml.="  <name>".html_entity_decode(ALL_REQUESTS)."</name>\n";
$xml.="  <value>".($glm->passedCount + $glm->blockedCount)."</value>\n";
$xml.=" </statistik>\n";
$xml.=" <statistik>\n";
$xml.="  <name>".html_entity_decode(NOK_REQUESTS)."</name>\n";
$xml.="  <value>".$glm->blockedCount."</value>\n";
$xml.=" </statistik>\n";
$xml.=" <statistik>\n";
$xml.="  <name>".html_entity_decode(OK_REQUESTS)."</name>\n";
$xml.="  <value>".($glm->passedCount)."</value>\n";
$xml.=" </statistik>\n";
$xml.=" <statistik>\n";
$xml.="  <name>".SPAM_RATE."</name>\n";
$xml.="  <value>".($glm->prozentualValue)."</value>\n";
$xml.=" </statistik>\n";

$count = count($glm->mailQueue);
$xml.=" <logtabelle>\n";
for($i=0;$i<$count;$i++){
    $xml.="  <entries>\n";
    $xml.="   <entry>\n";
    $xml.="    <key>".FROM_IP."</key>\n";      
    $xml.="    <value>".$glm->logTable[$i]["remoteIP"]."</value>\n";    
    $xml.="   </entry>\n";    
    $xml.="   <entry>\n";
    $xml.="    <key>".FROM_MAIL."</key>\n";      
    $xml.="    <value>".strip_tags($glm->mailQueue[$i]["mailFrom"])."</value>\n";    
    $xml.="   </entry>\n";   
    $xml.="   <entry>\n";
    $xml.="    <key>".html_entity_decode(TO_MAIL)."</key>\n";      
    $xml.="    <value>".strip_tags($glm->mailQueue[$i]["rcptTo"])."</value>\n";    
    $xml.="   </entry>\n";   
    $xml.="   <entry>\n";
    $xml.="    <key>".html_entity_decode(BLOCKED)."</key>\n";      
    $xml.="    <value>".$glm->mailQueue[$i]["blockedCount"]."</value>\n";    
    $xml.="   </entry>\n";   
    $xml.="   <entry>\n";
    $xml.="    <key>".html_entity_decode(PASSED)."</key>\n";      
    $xml.="    <value>".strip_tags($glm->mailQueue[$i]["passCount"])."</value>\n";    
    $xml.="   </entry>\n";   
    $xml.="   <entry>\n";
    $xml.="    <key>".html_entity_decode(ENTRY_AT)."</key>\n";      
    $xml.="    <value>".date(TIME_SCHEME,$glm->mailQueue[$i]["creationTime"])."</value>\n";    
    $xml.="   </entry>\n";   
    $xml.="   <entry>\n";
    $xml.="    <key>".html_entity_decode(LAST_UPDATE)."</key>\n";      
    $xml.="    <value>".date(TIME_SCHEME,$glm->mailQueue[$i]["lastUpdate"])."</value>\n";    
    $xml.="   </entry>\n";                           
    $xml.="   <entry>\n";
    $xml.="    <key>".html_entity_decode(EXPIRES)."</key>\n";      
    $xml.="    <value>".date(TIME_SCHEME,$glm->mailQueue[$i]["greyExpires"])."</value>\n";    
    $xml.="   </entry>\n";                           
    $xml.="  </entries>\n";    
    }
$xml.=" </logtabelle>\n";    	    

$xml.="</glm>\n";
header("content-type: text/xml; charset=utf-8");
echo utf8_encode($xml);
?>