<?php
/*
Plesk Spamdyke Control Panel (Version see version.php) - GUI for Plesk spamdyke implementation

Copyright (C) [2008] [Matthias Hackbarth / www.haggybear.de]

This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as 
published by the Free Software Foundation; either version 3 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty 
of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program; if not, see <http://www.gnu.org/licenses/>.
*/
require("./paa.class.php");

class readlog extends paa{


      var $versionUrl = "http://www.haggybear.de/download/scp";

      var $scpAllowed = false;
      
      var $maxStrLen = 30;

      var $queryString;      

      var $fehler;

      var $erfolg;

      var $domainId;

      var $allDomains;
      
      var $infoLog;
      
      var $errorLog;
      
      var $blocked = 0;
      
      var $delayed = array();

      var $blockedType = array();
      
      var $allowed = 0;
      
      var $logTable;

      var $spamDykeConf;

      var $spamDykeInstalled = true;

      var $spamDykeConfError = false;

      var $allLists;

      var $dieRechte;
 
      var $anzVars;
      
      var $suchmuster = false;

      var $logRotates;
      
         function __construct($sess,$getVars,$db){
                 parent::paa($sess,$getVars["dom_name"],$db);
		 parent::openDatabase();
		 parent::setPleskSkin();
		 parent::setPleskAllowed();
		 $this->domainId = $getVars["dom_id"];
		 parent::setPleskAllowedDomains($getVars["cl_id"]);
                 $this->setSpamDykeConf();
		 $this->setScpAllowed();
		 parent::setOnlyAdm($getVars["onlyadm"]);
                 $this->dieRechte = new AdminRights($getVars["dom_name"]);
                 
                 $this->anzVars["anz_PerPage"] = DEFAULT_PERPAGE;
                 $this->anzVars["anz_GlPaar"] = false;
                 $this->anzVars["anz_Filter"] = false;
                 $this->anzVars["anz_Richtung"] = false;
                 $this->anzVars["anz_Von"] = false;
                 }

        function __destruct(){
                 parent::closeDatabase();
                 }

        function setLogRotates(){

                 $res = mysql_query("SELECT time FROM ".$this->spamDykeConf["config-mysql-database"].".spamdyke_log_table group by DATE_FORMAT(time,'%d.%m.%y') order by time desc");

                 while($data = mysql_fetch_object($res)){
                       $this->logRotates[] = $data->time;
                       }
                 }

	function getAllDomainsAndAliases(){
	

	         $doms[] = $this->plesk_domain;

	         $hasDomAlias = false;
	         
	         if(mysql_num_rows(mysql_query("SHOW TABLES LIKE 'domainaliases'"))>0) $hasDomAlias = true;
                 $result = mysql_query("SELECT a.id, a.name, b.id FROM psa.domainaliases AS a, psa.domains AS b WHERE b.name = '".$this->plesk_domain."' AND b.id = a.dom_id");
                 if($result && $hasDomAlias){
                    while($data = mysql_fetch_object($result)){
                          $doms[] = $data->name;
	                  }
	            }
		 return $doms;

	         }
	
	function setScpAllowed(){
 
		 if($this->plesk_session->chkLevel(IS_ADMIN)){
                 $this->scpAllowed = true;
                 return;
                 }
 
               }
               
       function getAllowedDoms(){
       	        
       	        if(count($this->plesk_allowed_domains)==1) return $this->plesk_allowed_domains[0];
       	        
       	        echo "<select class=\"name\" name=\"doms\" onChange=\"document.location.href=this.value\">\n";
       	        while (list($key, $val) = each($this->plesk_allowed_domains)){
       	               $selected = ($this->plesk_domain == $key)?"selected":"";	
                      echo "<option value=\"".$val."\" $selected>".$key."</option>\n";
       	              }
		echo "</select>";
		
       	        
       	        }

       function canUse($recht){
               if($this->plesk_session->chkLevel(IS_ADMIN)) return true;

               if($this->dieRechte->alleRechte[$this->allDomains[0]][$recht]) return true;

               return false;               

               }

      function randomColor(){
               $zr=mt_rand(127,255);
               $zg=mt_rand(127,255);
               $zb=mt_rand(127,255);
               
	       $r = dechex($zr<0?0:($zr>255?255:$zr));
               $g = dechex($zg<0?0:($zg>255?255:$zg));
               $b = dechex($zb<0?0:($zb>255?255:$zb));

               $color = (strlen($r) < 2?'0':'').$r;
               $color .= (strlen($g) < 2?'0':'').$g;
               $color .= (strlen($b) < 2?'0':'').$b;
               $farbe = '#'.$color;
               
               #$farbe="rgb(".$zr.",".$zg.",".$zb.");";

               return $farbe;

               }


       function setSpamDykeConf(){

                $neededLoglevels = array("info","verbose","debug","excessive");
		$this->spamDykeConf = array();

                exec('./wrapper "1" "readconf '.SPAMDYKE_CONFIG.'"', $out);
                if(count($out)>2){
                  
                   for($i=0;$i<count($out);$i++){
                      $tmp = explode("=",$out[$i]);
                      if(isset($this->spamDykeConf[$tmp[0]])) $tmp[0].="SCP".rand(0,10000);
                      $this->spamDykeConf[$tmp[0]] = $tmp[1];
                      }

                }else{
                $this->spamDykeInstalled = false;
                return;
                }

                if(empty($this->spamDykeConf["log-level"])){
                  $this->spamDykeConfError = SCP_NO_LOG_LEVEL;
                  $this->spamDykeInstalled = false;
                }else if(empty($this->spamDykeConf["config-mysql-database"])){
                  $this->spamDykeConfError = SCP_NO_DATABASE_SUPPORT;
                  $this->spamDykeInstalled = false;
                }else if(!in_array($this->spamDykeConf["log-level"],$neededLoglevels)){
                  $this->spamDykeConfError = SCP_WRONG_LOG_LEVEL;
                  $this->spamDykeInstalled = false;
                }
   }

     function getScpAllowed(){
              return $this->scpAllowed;
              }
              

     function checkVersion($v){
		$url = $this->versionUrl.".txt";
 	   	$p = fopen($url,"r");
	 	$ver  = fgets($p,16);
	 	fclose($fp);

		if($this->plesk_session->chkLevel(IS_ADMIN) && AUTOUPDATE){
	           if($v != $ver){ 
 		      echo "<a href=\"?".$this->queryString."&action=update\">".str_replace("{VER}",$ver,SCP_VERSION_UPD)."</a>";
		      return;
		      }
	        }
	     
	 	if($v != $ver){
		   echo "<a href=\"".$this->versionUrl.".zip\">".str_replace("{VER}",$ver,SCP_VERSION_NOK)."</a>";
		   return;
		   }
	 
	 	echo SCP_VERSION_OK;
        	}
		
	     
     function setQueryString($qs){
            	$expr = '/statmessage=(.*)&/i';
		$qs = preg_replace($expr, '', $qs);
		$expr = '/&todo=(.*)/i';
		$qs = preg_replace($expr, '', $qs);
		$expr = '/&admin=(.*)/i';
		$qs = preg_replace($expr, '', $qs);
                $expr = '/&action=(.*)/i';
		$qs = preg_replace($expr, '', $qs);
		$this->queryString = $qs;
              }

     function getQueryString(){
              echo $this->queryString;
              }

     function getError(){
              if(empty($this->fehler))return;
              $this->fehler[] = "&nbsp;";
              echo "<span class=\"fatred\">&nbsp;&nbsp;".implode("<br>&nbsp;&nbsp;",$this->fehler)."<span>";

              }

     function getErfolg(){
              if(empty($this->erfolg))return;
              $this->erfolg[] = "&nbsp;";
              echo "<span class=\"fatgreen\">&nbsp;&nbsp;".implode("<br>&nbsp;&nbsp;",$this->erfolg)."<span>";

              }


     function readQmailLogs(){
              $this->setLogRotates();
	      $this->allDomains = $this->getAllDomainsAndAliases();
              $dasLog = substr($this->logRotates[0],0,10);

              if(!$this->dieRechte->isAllView){
	         $searchStr = "AND ( `to` LIKE '%@".implode("' OR `to` LIKE '%@",$this->allDomains)."' or ";
                 $searchStr.= " `from` LIKE '%@".implode("' OR `from` LIKE '%@",$this->allDomains)."')";
		 }

              if($this->anzVars["anz_Von"]) $dasLog = $this->anzVars["anz_Von"];

              

              $res = mysql_query("SELECT id,reason FROM ".$this->spamDykeConf["config-mysql-database"].".spamdyke_log_table WHERE date_format(time,'%Y-%m-%d') = '".$dasLog."' ".$searchStr." AND reason != 'allowed'");
              while($data = mysql_fetch_array($res)){
                    $this->blocked++;
                    $this->blockedType[$data["reason"]]++;
                    }

              $res = mysql_query("SELECT * FROM ".$this->spamDykeConf["config-mysql-database"].".spamdyke_log_table WHERE date_format(time,'%Y-%m-%d') = '".$dasLog."' ".$searchStr." AND reason = 'allowed'");
              while($data = mysql_fetch_array($res)){
                    $this->allowed++;
                       if($this->checkLogTableForFormerGreylisting($data)){
                          $this->blocked--;
                          $this->blockedType["DENIED_GRAYLISTED"]--;
                          }
                    }

             #echo "<hr>Dauer: ".($stop-$start)." sek.";
                    

	      }

     function readList($type){
              exec('./wrapper "1" "readlists cat '.$this->spamDykeConf[$type."-file"].'"', $out);
              $this->allLists["my"][$type] = array();
              $this->allLists["others"][$type] = array();
              $my = false;
             
	      for($i=0;$i<count($out);$i++){

                  if(trim($out[$i]) == "#".$this->allDomains[0]."-start"){
                     $my = true;
                     $i++;
                     }
 
                  if(trim($out[$i]) == "#".$this->allDomains[0]."-end"){
                     $my = false;
                     $i++;
                     }

            
                  if($my){
                     $this->allLists["my"][$type][] = $out[$i]; 
                     }
                  else{
		     $this->allLists["others"][$type][] = $out[$i]; 
                    }
                  }
 
              }

     function setAllLists($data){

             $isWhite = (isset($data["whitelist"]))?true:false;             
	     $isBlack = (isset($data["blacklist"]))?true:false;  

             if($isWhite) $tmpWhite = explode("\n",$data["whitelist"]);
             if($isBlack) $tmpBlack = explode("\n",$data["blacklist"]);

	     if($isWhite) $saveWhite = trim(implode("\n",$this->allLists["others"][$data["type"]."-whitelist"]));
	     if($isBlack) $saveBlack = trim(implode("\n",$this->allLists["others"][$data["type"]."-blacklist"]));

             if(!empty($saveWhite)) $saveWhite = $saveWhite."\n";
             if(!empty($saveBlack)) $saveBlack = $saveBlack."\n";

             if($isWhite){
                $myWhite = trim(implode("\n",$tmpWhite));
                $check = empty($myWhite);
                if(!$check)$saveWhite.= "#".$this->allDomains[0]."-start\n".implode("\n",$tmpWhite)."\n#".$this->allDomains[0]."-end";
                }
	     if($isBlack){
                $myBlack = trim(implode("\n",$tmpBlack));
                $check = empty($myBlack);
                if(!$check)$saveBlack.= "#".$this->allDomains[0]."-start\n".implode("\n",$tmpBlack)."\n#".$this->allDomains[0]."-end";
                }

             if($isWhite) exec('./wrapper "1" "writeconf '.$this->spamDykeConf[$data["type"]."-whitelist-file"].'" "'.$saveWhite.'"');
	     if($isBlack) exec('./wrapper "1" "writeconf '.$this->spamDykeConf[$data["type"]."-blacklist-file"].'" "'.$saveBlack.'"');

             if($isWhite) $this->readList($data["type"]."-whitelist");
             if($isBlack) $this->readList($data["type"]."-blacklist");

             }

     function checkForGreylisting($val,$edit){

              if(trim($val["isgreylisted"]) != "" && (trim($val["adminsave"]) == "" && trim($val["jetztsuchen"]) == "")) $this->changeGreylisting($val);
     
              $select = (is_dir($this->spamDykeConf["graylist-dir"]."/".$this->allDomains[0]))?"selected":"";
	      
	      if($this->spamDykeConf["graylist-level"] == "always-create-dir"){
                 echo VALUE_ACT;
                }
              else if($this->spamDykeConf["graylist-level"] == "none"){
                 echo VALUE_DEACT;
                }
              else{
              
                 if($edit){
                    echo "<select name=\"isgreylisted\" onChange=\"document.scpedit.submit()\">\n";
	            echo "<option value=\"0\">".VALUE_DEACT."</option>\n";
	            echo "<option value=\"1\" ".$select.">".VALUE_ACT."</option>\n";
	            echo "</select>";
                 }else{
                    echo (is_dir($this->spamDykeConf["graylist-dir"]."/".$this->allDomains[0]))?VALUE_ACT:VALUE_DEACT;
                 }
              }
     
              }

     function changeGreylisting($val){

              $theCmd = "setgl";
              if(!$val["isgreylisted"]) $theCmd = "delgl";
     
              for($i=0;$i<count($this->allDomains);$i++){
                  exec ('./wrapper "1" "'.$theCmd.' '.$this->spamDykeConf["graylist-dir"].' '.$this->allDomains[$i].'"');
                  }
              
              }
     
     
     function getAllBlocked(){
     
              $neededLogEntries = null;

              if(!$this->dieRechte->isAllView){
                 $searchStr = "AND ( `to` LIKE '%@".implode("' OR `to` LIKE '%@",$this->allDomains)."' or ";
                 $searchStr.= " `from` LIKE '%@".implode("' OR `from` LIKE '%@",$this->allDomains)."')";
                 }

              if($this->suchmuster){
                 $searchStr.=" AND (";
                 $searchStr.=" `reason` LIKE '%".$this->suchmuster."%' or";
                 $searchStr.=" `from` LIKE '%".$this->suchmuster."%' or";
                 $searchStr.=" `to` LIKE '%".$this->suchmuster."%' or";
                 $searchStr.=" `rdns` LIKE '%".$this->suchmuster."%')";
                 }
		 
	     if($this->anzVars["anz_Filter"]){
                 $searchStr.=" AND (";
                 $searchStr.=" `reason` = '".$this->anzVars["anz_Filter"]."')";
                 }

             if($this->anzVars["anz_Richtung"]){
	         if($this->anzVars["anz_Richtung"] == SCP_DIRECTION_LOCAL){
                    $searchStr = "AND ( `to` LIKE '%@".implode("' OR `to` LIKE '%@",$this->allDomains)."' AND ";
                    $searchStr.= " `from` LIKE '%@".implode("' OR `from` LIKE '%@",$this->allDomains)."')";
		    $searchStr.= "AND `auth` != '(unknown)'";
                 }
		 if($this->anzVars["anz_Richtung"] == SCP_DIRECTION_OUT){
                    $searchStr = "AND ( `from` LIKE '%@".implode("' OR `from` LIKE '%@",$this->allDomains)."')";
		    $searchStr.= "AND `auth` != '(unknown)'";
                 }

		 if($this->anzVars["anz_Richtung"] == SCP_DIRECTION_IN){
		    $searchStr.= "AND `auth` = '(unknown)'";
                 }
	     }



		 
              $dasLog = $dasLog = substr($this->logRotates[0],0,10);
              if($this->anzVars["anz_Von"]) $dasLog = $this->anzVars["anz_Von"];
              $res = mysql_query("SELECT * FROM ".$this->spamDykeConf["config-mysql-database"].".spamdyke_log_table WHERE date_format(time,'%Y-%m-%d') = '".$dasLog."' ".$searchStr." ORDER BY time DESC LIMIT 0,".$this->anzVars["anz_PerPage"]);
              while($data = mysql_fetch_object($res)){
                       $logArray["time"] = strtotime($data->time); 
                       $logArray["reason"] = $data->reason;
		       $logArray["from"] = $data->from;
		       $logArray["to"] = $data->to;
		       $logArray["ip"] = $data->ip;
		       $logArray["rdns"] = $data->rdns;
		       $logArray["auth"] = $data->auth;
                       $logArray["color"] = $this->delayed[$data->reason][$data->id][0];
                       $logArray["delay"] = $this->delayed[$data->reason][$data->id][1];

                       if($data->reason == "DENIED_GRAYLISTED" && !empty($logArray["color"]) && !$this->anzVars["anz_GlPaar"]) continue;

                       
                       if($this->suchmuster){
                       	  
                       	  if(eregi($this->suchmuster,$logArray["reason"])){
                       	     $logArray["reason"] = str_replace($this->suchmuster,"<span class=\"sucherg\">".$this->suchmuster."</span>",$logArray["reason"]);
                       	     }
                       	     

			  if(eregi($this->suchmuster,$logArray["from"])){
                       	     $logArray["from"] = str_replace($this->suchmuster,"<span class=\"sucherg\">".$this->suchmuster."</span>",$logArray["from"]);
                       	     }

			  if(eregi($this->suchmuster,$logArray["to"])){
                       	     $logArray["to"] = str_replace($this->suchmuster,"<span class=\"sucherg\">".$this->suchmuster."</span>",$logArray["to"]);
                       	     }

			  if(eregi($this->suchmuster,$logArray["ip"])){
                       	     $logArray["ip"] = str_replace($this->suchmuster,"<span class=\"sucherg\">".$this->suchmuster."</span>",$logArray["ip"]);
                       	     }

			  if(eregi($this->suchmuster,$logArray["rdns"])){
                       	     $logArray["rdns"] = str_replace($this->suchmuster,"<span class=\"sucherg\">".$this->suchmuster."</span>",$logArray["rdns"]);
                       	     }                       	     
                       	 
                       	  }
                       
		      
                       
                       if(eregi("(@".implode("|@",$this->allDomains).")",$logArray["to"]) && 
                          eregi("(@".implode("|@",$this->allDomains).")",$logArray["from"]) &&
			  $logArray["auth"] != "(unknown)"){
                       	  $logArray["direction"] = SCP_DIRECTION_LOCAL;
                       	  }
                       else if(eregi("(@".implode("|@",$this->allDomains).")",$logArray["from"])){
                       	  $logArray["direction"] = SCP_DIRECTION_OUT;
                       	  }
                       else{
                          $logArray["direction"] = SCP_DIRECTION_IN;
                          }
		      
		       
		       $this->logTable[] = $logArray;
	       
	          }
	     }
	     
     function checkLogTableForFormerGreylisting($entry){

              $tmpColor = $this->randomColor();
              $retVal = false;

              $dasLog = substr($this->logRotates[0],0,10);
              if($this->anzVars["anz_Von"]) $dasLog = $this->anzVars["anz_Von"];

              $where = "`from` = '".$entry["from"]."' AND `to` = '".$entry["to"]."' AND (`ip` = '".$entry["ip"]."' or `rdns` = '".$entry["rdns"]."') AND (reason = 'DENIED_GRAYLISTED' OR reason = 'ALLOWED') AND time < '".$entry["time"]."'";
              $where.= " AND date_format(time,'%Y-%m-%d') = '".$dasLog."' LIMIT 1";
              $res = mysql_query("SELECT id,time,reason FROM ".$this->spamDykeConf["config-mysql-database"].".spamdyke_log_table WHERE $where");
              while($data = mysql_fetch_array($res)){
                    if($data["reason"] != "DENIED_GRAYLISTED") return $retVal;
                    $retVal = true;
                    $delay = strtotime($entry["time"]) - strtotime($data["time"]);
                    $this->delayed[$entry["reason"]][$entry["id"]] = array($tmpColor,$delay);
                    $this->delayed[$data["reason"]][$data["id"]] = array($tmpColor);
                 } 
              return $retVal;
              }


     function getSpamrate(){
     
              $allRequest = $this->allowed + $this->blocked;
	      
	      return str_replace(".",",",round($this->blocked / ($allRequest / 100),2));


     
              }	     
    
     function getLogTable(){

              $count = count($this->logTable);
              
              for($i=0;$i<$count;$i++){

                 $dieClass = "fatred";

                 if(stristr($this->logTable[$i]["reason"],"ALLOWED")){
                    $dieClass = "fatgreen";
                 }


                 $color = (empty($this->logTable[$i]["color"]) || !$this->anzVars["anz_GlPaar"])?"#FFFFFF":$this->logTable[$i]["color"];
	      
	         echo "<tr bgcolor=\"$color\" onMouseOver=\"this.bgColor='#ccffc'\" onMouseOut=\"this.bgColor='$color'\" class=\"".$dieClass."\">\n";
                 
                 if($this->logTable[$i]["direction"] == SCP_DIRECTION_IN){
                    echo "<td><img src=\"in.gif\" width=\"15\" height=\"15\"></td>";
                    }
                 else if($this->logTable[$i]["direction"] == SCP_DIRECTION_OUT){
                    echo "<td><img src=\"out.gif\" width=\"15\" height=\"15\"></td>";
                   }
                 else{
                    echo "<td><img src=\"local.gif\" width=\"15\" height=\"15\"></td>";
                   }
                 
                 echo "<td>".$this->logTable[$i]["direction"]."</td>";
                 echo "<td TITLE=\"".strip_tags($this->logTable[$i]["from"])."\" onMouseOut=\"toggleDirectList('".$i."_sender',0)\" onMouseOver=\"toggleDirectList('".$i."_sender',1)\">".$this->cutToLong($this->logTable[$i]["from"])."<br><div style=\"position:absolute;padding:3px 3px 3px 3px;background:#FFFFFF\" class=\"invis\" id=\"".$i."_sender\">&nbsp;<img style=\"cursor:pointer\" src=\"help_ico.gif\" border=\"0\" onClick=\"getPageContent('cm.php?addy=".strip_tags($this->logTable[$i]["from"])."','".strip_tags($this->logTable[$i]["from"])."','mail')\">&nbsp;<img style=\"cursor:pointer\" src=\"wl.jpg\" border=\"0\" onClick=\"setWhite('senderlists','".strip_tags($this->logTable[$i]["from"])."')\">&nbsp;&nbsp;<img style=\"cursor:pointer\" src=\"bl.jpg\" border=\"0\" onClick=\"setBlack('senderlists','".strip_tags($this->logTable[$i]["from"])."')\">&nbsp;</div></td>";
	      	 echo "<td TITLE=\"".strip_tags($this->logTable[$i]["to"])."\" onMouseOut=\"toggleDirectList('".$i."_recipient',0)\" onMouseOver=\"toggleDirectList('".$i."_recipient',1)\">".$this->cutToLong($this->logTable[$i]["to"])."<br><div style=\"position:absolute;padding:3px 3px 3px 3px;background:#FFFFFF\" class=\"invis\" id=\"".$i."_recipient\">&nbsp;<img style=\"cursor:pointer\" src=\"wl.jpg\" border=\"0\" onClick=\"setWhite('recipientlists','".strip_tags($this->logTable[$i]["to"])."')\">&nbsp;&nbsp;<img style=\"cursor:pointer\" src=\"bl.jpg\" border=\"0\" onClick=\"setBlack('recipientlists','".strip_tags($this->logTable[$i]["to"])."')\">&nbsp;</div></td>";
   	         if($this->logTable[$i]["delay"]){
    	            echo "<td><div style=\"float:left\">".$this->logTable[$i]["reason"]."</div><div style=\"float:left\" onMouseOut=\"toggleDirectList('".$i."_delay',0)\" onMouseOver=\"toggleDirectList('".$i."_delay',1)\"><img src=\"time.gif\" border=\"0\"></div><br><div style=\"position:absolute;padding:3px 3px 3px 3px;background:#FFFFFF;color:#000000;float:left\" class=\"invis\" id=\"".$i."_delay\">&nbsp;".$this->minutes($this->logTable[$i]["delay"])." ".SCP_GRAYLIST_MIN."&nbsp;</div></td>";
    	            }
    	         else{
    	            echo "<td>".$this->logTable[$i]["reason"]."</td>";
    	            }
		 echo "<td onMouseOut=\"toggleDirectList('".$i."_ip',0)\" onMouseOver=\"toggleDirectList('".$i."_ip',1)\">".$this->logTable[$i]["ip"]."<br><div style=\"position:absolute;padding:3px 3px 3px 3px;background:#FFFFFF\" class=\"invis\" id=\"".$i."_ip\">&nbsp;<img style=\"cursor:pointer\" src=\"help_ico.gif\" border=\"0\" onClick=\"getPageContent('ident.php?dieip=".$this->logTable[$i]["ip"]."','".$this->logTable[$i]["ip"]."','ip')\">&nbsp;<img style=\"cursor:pointer\" src=\"wl.jpg\" border=\"0\" onClick=\"setWhite('iplists','".$this->logTable[$i]["ip"]."')\">&nbsp;&nbsp;<img style=\"cursor:pointer\" src=\"bl.jpg\" border=\"0\" onClick=\"setBlack('iplists','".$this->logTable[$i]["ip"]."')\">&nbsp;</div></td>";
                 echo "<td TITLE=\"".strip_tags($this->logTable[$i]["rdns"])."\" onMouseOut=\"toggleDirectList('".$i."_rdns',0)\" onMouseOver=\"toggleDirectList('".$i."_rdns',1)\">".$this->cutToLong($this->logTable[$i]["rdns"])."<br><div style=\"position:absolute;padding:3px 3px 3px 3px;background:#FFFFFF\" class=\"invis\" id=\"".$i."_rdns\">&nbsp;<img style=\"cursor:pointer\" src=\"wl.jpg\" border=\"0\" onClick=\"setWhite('rdnslists','".strip_tags($this->logTable[$i]["rdns"])."')\">&nbsp;</div></td>";;
		 echo "<td>".date("d. M. H:i:s",$this->logTable[$i]["time"])."</td>";
		 echo "</tr>";
		 }

               

              }	  
              
      function cutToLong($str){
               $all = strip_tags($str);
               if(strlen($all) != strlen($str)) return $str;
               
               if(strlen($all) > $this->maxStrLen){
      	       	  return substr($all,0,$this->maxStrLen)."...";
      	       	  }
      	       	  
      	       return $str;
      	
      	       }    

      function getPerPageOpt(){

               $opts = array(25,50,100,200,500,1000,5000);
               $box = new optionboxes("anz_PerPage");
               $box->setSelPoint($this->anzVars["anz_PerPage"]);
               $box->setEvent("onChange=\"document.anzeige.submit()\"");
               $box->getBox($opts,$opts);

               }

      function getGlPaarOpt(){

               $opts = array(0,1);
               $vals = array(VALUE_NO,VALUE_YES);

               $box = new optionboxes("anz_GlPaar");
               $box->setSelPoint($this->anzVars["anz_GlPaar"]);
               $box->setEvent("onChange=\"document.anzeige.submit()\"");
               $box->getBox($opts,$vals);
               }

     function getFilterOpt(){
               $opts = array(false,"ALLOWED");
               $vals = array(SCP_ALL,"ALLOWED");
               $blockTypes = $this->blockedType;
               while (list($key) = each($blockTypes)){
                      $opts[] = $key;
                      $vals[] = $key;
                      }
               unset($blockTypes);
               $box = new optionboxes("anz_Filter");
               $box->setSelPoint($this->anzVars["anz_Filter"]);
               $box->setEvent("onChange=\"document.anzeige.submit()\"");
               $box->getBox($opts,$vals);
               }
               
     function getRichtungOpt(){

               $opts = array(false,SCP_DIRECTION_IN,SCP_DIRECTION_OUT,SCP_DIRECTION_LOCAL);
               $vals = array(SCP_ALL,SCP_DIRECTION_IN,SCP_DIRECTION_OUT,SCP_DIRECTION_LOCAL);
               $box = new optionboxes("anz_Richtung");
               $box->setSelPoint($this->anzVars["anz_Richtung"]);
               $box->setEvent("onChange=\"document.anzeige.submit()\"");
               $box->getBox($opts,$vals);
               }

     function getLogDate(){

               for($i=0;$i<count($this->logRotates);$i++){
                   $t = strtotime($this->logRotates[$i]); 
                   $vals[] = constant("SCP_MYSQL_DAY_".date("w",$t)).", ".date(SCP_MYSQL_VIEW_DATE_FORMAT,$t);
                   $opts[] = date("Y-m-d",$t);
                   }
               $box = new optionboxes("anz_Von");
               $box->setSelPoint($this->anzVars["anz_Von"]);
               $box->setEvent("onChange=\"document.anzeige.submit()\"");
               $box->getBox($opts,$vals);
               }               
               

     

      function getAdmin(){
               return $this->dieRechte;
               }

      function getStat(){

               $alle = $this->blocked + $this->allowed;
               
               echo "<tr bgcolor=\"#FFFFFF\">\n";
    	       echo "<td height=\"25\" width=\"150\">&nbsp;".strtoupper(SCP_ALL_MAILS).":</td>\n";
               echo "<td width=\"300\">\n";
               echo "<div id=\"stat\" style=\"background:#999999;width:200px; height:10px;\"></div><div style=\"float:left\">&nbsp;100 %</div>\n";
               echo "</td>\n";
               echo "<td height=\"25\" width=\"190\">".$alle."</td>\n";
               echo "</tr>\n";
               echo "<tr bgcolor=\"#FFFFFF\">\n";
    	       echo "<td height=\"25\" width=\"150\">&nbsp;".strtoupper(SCP_ALLOWED).":</td>\n";
               echo "<td width=\"300\">\n";
               echo "<div id=\"stat\" style=\"background:#009900;width:".($this->makeProz($alle,$this->allowed,0) * 2)."px; height:10px;\"></div><div style=\"float:left\">&nbsp;".$this->makeProz($alle,$this->allowed,2)." %</div>\n";
               echo "</td>\n";
               echo "<td height=\"25\" width=\"190\">".$this->allowed."</td>\n";
               echo "</tr>\n";
               echo "<tr bgcolor=\"#FFFFFF\">\n";
    	       echo "<td height=\"25\" width=\"150\">&nbsp;".strtoupper(SCP_DROPPED_MAILS).":</td>\n";
               echo "<td width=\"300\">\n";
               echo "<div id=\"stat\" style=\"background:#FF0000;width:".($this->makeProz($alle,$this->blocked,0) * 2)."px; height:10px;\"></div><div style=\"float:left\">&nbsp;".$this->makeProz($alle,$this->blocked,2)." %</div>\n";
               echo "</td>\n";
               echo "<td height=\"25\" width=\"190\">".$this->blocked."</td>\n";
               echo "</tr>\n";
               
               if(count($this->delayed["ALLOWED"]) > 0){
                        $delay = array();
                        while (list($key) = each($this->delayed["ALLOWED"])){
                            $delay[] = $this->delayed["ALLOWED"][$key][1];
                            }
               	
               	        echo "<tr bgcolor=\"#FFFFFF\">\n";
    	                echo "<td height=\"25\" width=\"150\" style=\"vertical-align:top\">&nbsp;".SCP_GREYLIST_DELAY."</td>\n";
                        echo "<td width=\"300\" style=\"vertical-align:top\">\n";
                        echo SCP_GREYLIST_DELAY_AVERAGE."<br>";
                        echo SCP_GREYLIST_DELAY_MAX."<br>";
                        echo SCP_GREYLIST_DELAY_MIN."<br>";
                        echo "</td>\n";
                        echo "<td height=\"25\" width=\"190\">";
                        echo $this->minutes((array_sum($delay) / count($delay)))." ".SCP_GRAYLIST_MIN."<br>";
                        echo $this->minutes(max($delay))." ".SCP_GRAYLIST_MIN."<br>";
                        echo $this->minutes(min($delay))." ".SCP_GRAYLIST_MIN."<br>";
                        echo "</td>\n";
                        echo "</tr>\n";
                      }

               echo "<tr><td colspan=\"3\" height=\"5\" bgcolor=\"#FFFFFF\"></td></tr>";
               echo "<tr><td colspan=\"3\" height=\"1\" bgcolor=\"#000000\"></td></tr>";
               echo "<tr><td colspan=\"3\" height=\"5\" bgcolor=\"#FFFFFF\"></td></tr>";          
  
               while (list($key, $val) = each($this->blockedType)){
                    echo "<tr bgcolor=\"#FFFFFF\">\n";
    	            echo "<td height=\"25\" width=\"150\">&nbsp;".strtoupper($key).":</td>\n";
                    echo "<td width=\"300\">\n";
                    echo "<div id=\"stat\" style=\"background:#FF9900;width:".($this->makeProz($this->blocked,$val,0) * 2)."px; height:10px;\"></div><div style=\"float:left\">&nbsp;".$this->makeProz($this->blocked,$val,2)." %</div>\n";
                    echo "</td>\n";
                    echo "<td height=\"25\" width=\"190\">".$val."</td>\n";
                    echo "</tr>\n";
                    }
               }

     function makeProz($s, $w, $r){
              $w = (100 / $s * $w);
              $w = round($w,$r);
              return str_replace(".",",",$w);
              }

     function minutes ($sec) {
              return sprintf('%02d:%02d', floor($sec/60), $sec % 60);
              } 

     }
              

?>