<?php
/*
Plesk Greylisting Manager (Version see version.php) - GUI for Plesk greylisting implementation by Parallels

Copyright (C) [2009] [Matthias Hackbarth / www.haggybear.de]

This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as 
published by the Free Software Foundation; either version 3 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty 
of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program; if not, see <http://www.gnu.org/licenses/>.
*/

apc_clear_cache();

include("./config.inc.php");
include("./version.php");
include("./lang/".LANG.".inc.php");
include("./glm.class.php");

$glm = new glm($session,$_GET,array(DB_HOST,DB_NAME,DB_USR,DB_PWD));
$glm->setQueryString($_SERVER["QUERY_STRING"]);
$glm->setViewpage($_GET["action"]);



if(isset($_GET["save_lists"]) && $session->chkLevel(IS_ADMIN))$glm->greylistingListSaveQuite($_GET);
if(isset($_GET["save_lists_p"]))$glm->greylistingListSavePQuite($_GET);
if(isset($_POST["but_search"]))$glm->suchmuster = $_POST["search"];

if(!$_POST["limit"]) $_POST["limit"] = "50";
if(!$_POST["filter"]) $_POST["filter"] = "all";


if(!$glm->getPleskAllowed()){
    #alert(lmsg('__perm_denied'));
    go_to_uplevel();
   }

if($_POST["export"] == "1"){
  $glm->greylistingProps($_POST);
  $glm->doExport();
  }

$glm->readAbuseSettings();
$glm->readRemoteSettings();

if($glm->viewPage == "abusemail"){
$glm->sendSpamReport($_POST);
exit;
}

?>
<html>
<head>
<title>Greylisting Stats</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<script language="javascript" type="text/javascript" src="/javascript/common.js"></script>
<script language="javascript" type="text/javascript" src="/javascript/chk.js.php"></script>
<script language="javascript" type="text/javascript" src="jquery.js"></script>
<?php if(PSA_VERSION < 10):?>
<link rel="stylesheet" type="text/css" href="/skins/<?php echo $glm->getPleskSkin();?>/css/general.css">
<link rel="stylesheet" type="text/css" href="/skins/<?php echo $glm->getPleskSkin();?>/css/main/custom.css">
<link rel="stylesheet" type="text/css" href="/skins/<?php echo $glm->getPleskSkin();?>/css/main/layout.css">
<link rel="stylesheet" type="text/nonsense" href="/skins/<?php echo $glm->getPleskSkin();?>/css/misc.css">
<?php else:?>
<link rel="stylesheet" href="/skins/<?php echo $glm->getPleskSkin();?>/css/base.css" type="text/css" />
<link rel="stylesheet" href="/skins/<?php echo $glm->getPleskSkin();?>/css/btns.css" type="text/css" />
<link rel="stylesheet" href="/skins/<?php echo $glm->getPleskSkin();?>/css/customer/main.css" type="text/css" />
<link rel="stylesheet" href="/skins/<?php echo $glm->getPleskSkin();?>/css/customer/custom.css" type="text/css" />
<?php endif;?>


<link rel="stylesheet" type="text/css" href="<?php echo (eregi("msie",$_SERVER["HTTP_USER_AGENT"]))?"doof":"schlau";?>_browser.css">
<style type="text/css">
<!--

table{
font-size:11px !important;
}
</style>
<script type="text/javascript">
<!--

var tmpColor = "";
var onScrWin = null;

function _body_onload(){
        loff();
        SetContext('<?php echo GLM_ADMIN;?>');
        <?php if(PSA_VERSION >= 10 && $_COOKIE["noFullScreen"]<>1):?>
        if(top.location != self.location){
          window.setTimeout('$("#fullscreen").slideDown("slow")',1000);
          }
        <?php endif;?>
	}
			
function _body_onunload(){
        lon();
	}
	

function nothere(t){
         alert("Still in development");
         }
				
var opt_no_frames = false;
var opt_integrated_mode = false;

function toggleSelection2(form,prename) {
	 var elements=form.elements;
	 for(i=0;i<elements.length;i++) {
	     var el=elements[i];
	     if(typeof el.name!="undefined") {
 	        if(el.name.indexOf(prename)==0) {
		   el.checked=!el.checked;
		   markSelected(el.checked,el.id.replace(/box_/,""));
	           }
	        }
	    }
	 }
	    
function toggleSelection(form,what) {
	 toggleSelection2(form,"kide_blfr_"+what);
	 }

function toggleBox(id){
         id = id.replace(/row_/,"box_");
	 
 	 document.getElementById(id).checked=!document.getElementById(id).checked;
	 
         }

function markSelected(sel,id){

         if(sel){
	    document.getElementById("row_"+id).bgColor = "<?php echo SELECTED_COLOR;?>";
	    }
	 else{
	    document.getElementById("row_"+id).bgColor = tmpColor;
	   }
	 }


function markOver(id){
         
         if(document.getElementById("box_"+id).checked){
	    document.getElementById("row_"+id).bgColor = "<?php echo HIGHSELECT_COLOR;?>";
	    }
	 else{
	    document.getElementById("row_"+id).bgColor = "<?php echo HIGHLIGHT_COLOR;?>";
	    }
         }

function markOut(id){
         if(document.getElementById("box_"+id).checked){
	    document.getElementById("row_"+id).bgColor = "<?php echo SELECTED_COLOR;?>";
	    }
	 else{
	    document.getElementById("row_"+id).bgColor = "";
	    }
         }
         
function abuseReport(vals,email){
    
	 yn = window.confirm(unescape("<?php echo GLM_SPAM_ABUSE_REPORT_DO;?>"));
	     if(!yn) return;
	     
             dieRows = document.getElementById("row_"+vals);
             dieTds = dieRows.getElementsByTagName("td");
             ip = dieTds[0].getAttribute('title');
             from = dieTds[1].getAttribute('title');
             to = dieTds[2].getAttribute('title');
             create = dieTds[5].getAttribute('title');
             $.post("index.php?<?php $glm->getQueryString(); ?>&action=abusemail",{rec:email, ip:ip, from: from, to: to, create: create }, function(data){
                    if(data.indexOf("emailwassend")>-1){
                       yn = window.confirm("<?php echo GLM_SPAM_ABUSE_REPORT_DO_OK;?>");
                       if(yn) closeWin('iplook');
                       }
                    else{
                       alert("<?php echo GLM_SPAM_ABUSE_REPORT_DO_NOK;?>"+data);
                       }
                  });
         }  

function getPageContent(strURL,IP,what) {
    var xmlHttpReq = false;
    
    var header_box = "<?php echo GETTING_IP_INFO;?>";
    if(what == "mail") header_box = "<?php echo CHECKING_EMAIL;?>";
    if(what == "stat") header_box = "<?php echo CHECKING_DATA;?>";
    
    <?php if($glm->plesk_session->chkLevel(IS_ADMIN)):?>
    if(what == "ip") strURL+="&abuse=<?php echo $glm->glmSettings["abuse"]["enabled"];?>";
    <?php endif;?>
       
     
    var loadContent = '<table width="600" height="250" border="0" cellpadding="0" cellspacing="0"><tr>'
                    + '<td align="center" valign="middle"><b>'+header_box+' ('+IP+')</b></td></tr><tr>'
                    + '<td align="center" valign="middle"><img src="loading.gif" width="220" height="19"></td></tr></table>'
    
							    
    var self = this;

    // Mozilla/Safari
    if (window.XMLHttpRequest) {
       self.xmlHttpReq = new XMLHttpRequest();
       }
    
    // IE
    else if (window.ActiveXObject) {
        self.xmlHttpReq = new ActiveXObject("Microsoft.XMLHTTP");
        }

    if(document.all)document.getElementById('iplook').style.marginTop = -225 + (document.body.scrollTop);
    updatepage(loadContent);
    
    self.xmlHttpReq.open('GET', strURL, true);
    
    self.xmlHttpReq.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
    
    self.xmlHttpReq.onreadystatechange = function() {
    if (self.xmlHttpReq.readyState == 4) {
        updatepage(self.xmlHttpReq.responseText);
        
        }
    }
    
    self.xmlHttpReq.send(null);
    
}
function updatepage(str){
    if(document.all){
       window.onscroll = function(){moveScrEvent('iplook');};
       $("#fader").show();
       $("#fader").fadeTo("fast",0.9,function(){$("#iplook").fadeIn("fast");});
       }
    else{
       $("#fader").fadeIn("fast",function(){$("#iplook").fadeIn("fast");});
       }
    document.getElementById("iplook_content").innerHTML = str;
    }
    
function killScrEvent(){
	 window.onscroll = null;
	 }
	 
function moveScrEvent(id){
	 document.getElementById(id).style.marginTop = -225 + (document.body.scrollTop);
	 }

function toggleDirectList(id,inOut){
         
         if(inOut){
            document.getElementById(id).className='vis'
            document.getElementById(id).style.border = "1px solid #000000";
            }
         else{
            document.getElementById(id).className='invis'
            document.getElementById(id).style.border = "none";
           }

         }

function closeWin(dasdiv){
         $("#"+dasdiv).fadeOut("fast",function(){$("#fader").fadeOut("fast");});
         killScrEvent();
         }
	 
function slideWl(wlid){
	       $("#"+wlid+"WL").slideToggle("fast");
         
         }
	
function setList(lName,lType){
         <?php if($session->chkLevel(IS_ADMIN)):?>
         var lists = new Object();
         lists["w"] = "<?php echo WHITELIST_DIRECT;?>";
         lists["b"] = "<?php echo BLACKLIST_DIRECT;?>";
         yn = window.confirm("<?php echo sprintf(NOTICE_LISTS_DIRECT,'"+lists[lType]+"','"+lists[lType]+"');?>");
         if(yn){
           $.ajax({
             type: "GET",
             url: "index.php",
             data: "<?php $glm->getQueryString();?>&action=list&"+lType+"="+lName+"&save_lists=true",
             success: function(msg){
               var msgArray = msg.replace (/^\s+/, '').replace (/\s+$/, '').split("|");
               document.getElementById("myListCounter").innerHTML = msgArray[0];
               document.getElementById("notice_content").innerHTML = msgArray[1];
	       if(document.all){
	          window.onscroll = function(){moveScrEvent('notice');};
                  $("#fader").show();
  		  $("#fader").fadeTo("fast",0.9,function(){$("#notice").fadeIn("fast");});	       
	       }else{
                  $("#fader").fadeIn("fast",function(){$("#notice").fadeIn("fast");});
		  }
               }
             });
           return;
           }
         document.location.href = "index.php?<?php $glm->getQueryString();?>&action=list&"+lType+"="+lName;
         <?php else:?>
         alert("<?php echo GLM_RIGHT_LISTS;?>");
         <?php endif;?>
         }
	 
function setPList(from,to,typ){
         var lists = new Object();
         lists["w"] = "<?php echo str_replace("&ouml;","%F6",P_WHITELIST_DIRECT);?>";
         lists["b"] = "<?php echo str_replace("&ouml;","%F6",P_BLACKLIST_DIRECT);?>";
         yn = window.confirm(unescape("<?php echo sprintf(NOTICE_LISTS_DIRECT,'"+lists[typ]+"','"+lists[typ]+"');?>"));
         if(yn){
           $.ajax({
             type: "GET",
             url: "index.php",
             data: "<?php $glm->getQueryString();?>&action=plist&save_lists_p="+typ+"&from="+from+"&to="+to,
             success: function(msg){
               var msgArray = msg.replace (/^\s+/, '').replace (/\s+$/, '').split("|");
	       document.getElementById("myPListCounter").innerHTML = msgArray[0];
               document.getElementById("notice_content").innerHTML = msgArray[1];
	       if(document.all){
	          window.onscroll = function(){moveScrEvent('notice');};
                  $("#fader").show();
  		  $("#fader").fadeTo("fast",0.9,function(){$("#notice").fadeIn("fast");});	       
	       }else{
                  $("#fader").fadeIn("fast",function(){$("#notice").fadeIn("fast");});
		  }
               }
             });
           return;
           }
	 document.location.href = "index.php?<?php $glm->getQueryString();?>&action=plist";
         }	

function doExport(){
         document.MailForm.export.value = "1";
         document.MailForm.submit();
         document.MailForm.export.value = "0";
         }

function fullscreen(){
top.location = "/smb/web/view";

dieBreite = Math.round(screen.width/100*90);
dieHoehe = Math.round(screen.height/100*90);

startx = (screen.width - dieBreite)/2;
starty = (screen.height - dieHoehe)/2;

GlmFenster = window.open(self.location, "GLMWindow", "width="+dieBreite+",height="+dieHoehe+",screenX="+startx+",screenX="+starty+",scrollbars=yes");
GlmFenster.focus();
}
//-->
</script>
<?php if(USE_FLATTR):?>
<script type="text/javascript">
/* <![CDATA[ */
(function() {
var s = document.createElement('script'), t = document.getElementsByTagName('script')[0];

s.type = 'text/javascript';
s.async = true;
s.src = 'http://api.flattr.com/js/0.5.0/load.js?mode=auto';

t.parentNode.insertBefore(s, t);
})();
/* ]]> */
</script>	
<?php endif;?>	
</head>

<body onLoad="_body_onload();" onUnload="_body_onunload();" id="mainCP" class="">
<div id="fader"></div>							      
<?php if(PSA_VERSION < 10):?>	
    <div class="pathbar"><a href="/domains/domains.php3" onclick="lon();">Domains</a> &gt; <a href="/domains/dom_ctrl.php3" onclick="lon();"><?php echo $_GET["dom_name"];?></a> &gt;</div>
	<div class="screenTitle">
          <table cellspacing="0" width="100%">
          <tbody>
          <tr>
            <td class="title"><div class='titleContainer clear'><h1><?php echo GLM_ADMIN;?> Domain <span class="name"><?php echo $_GET["dom_name"];?></span></h1></div>
	    </td>
            <td class="toolbar">
	    <?php if(USE_FLATTR):?>
            <div style="float:left;padding-top:7px"><a class="FlattrButton" style="display:none;" rev="flattr;button:compact;" href="http://www.haggybear.de/en/greylisting-manager"></a></div>
	    <?php endif;?>
	    <div class="toolbarWrapper">
	    <div class="toolbarItems">
	    <table cellspacing="0">
	    <tr>  
	    <td><div class="toolbarBtn" id="bid-up-level"><A name="up_level" id="up_level" href="/domains/dom_ctrl.php3?previous_page=subdomains" onClick=";lon();"><span><?php echo GLM_LEVEL_UP;?></span></a></div></td></tr>
           </table>	
         </div>
       </div>	
    </td>
  </tr>
 </tbody>
 </table>
</div>	
<?php else:?>
<div id="fullscreen">
<img src="full_screen.png" align="absmiddle">&nbsp;<a href="#" onClick="fullscreen()"><?php echo TOGGLE_FULLSCREEN;?></a>&nbsp;<img src="full_screen.png" align="absmiddle">
<div title="<?php echo NO_FULLSCREEN;?>" alt="<?php echo NO_FULLSCREEN;?>" id="fullscreen_no" onClick="$('#fullscreen').slideUp('slow');document.cookie = 'noFullScreen=1';">X</div>
</div>
<?php endif;?>	
<div id="iplook">
 <table width="630" border="0" cellspacing="0" cellpadding="0" height="20" bgcolor="black">
  <tr>
   <td align="right"><span class="iplook_close"><a href="javascript://" onClick="closeWin('iplook')">[<?php echo CLOSE_WINDOW;?>]</a></span>&nbsp;&nbsp;</td>
  </tr>
 </table>
<div id="iplook_content">
</div>
</div>
<div id="notice">
 <table width="220" border="0" cellspacing="0" cellpadding="0" height="20" bgcolor="black">
  <tr>
   <td align="right"><span class="iplook_close"><a href="javascript://" onClick="closeWin('notice')">[<?php echo CLOSE_WINDOW;?>]</a></span>&nbsp;&nbsp;</td>
  </tr>
 </table>
<div id="notice_content">
</div>
</div>
	
<table width="100%" border="0" cellspacing="0" cellpadding="0">
  <tr align="center" valign="middle"> 
    <td height="35"> 
      <h1><?php echo GLM_ADMIN;?> <?php echo GLM_VERSION;?>
&nbsp;&nbsp;
      [<?php $glm->checkVersion(GLM_VERSION);?>]</h1>
    </td>
  </tr>
  <tr align="center" valign="middle"> 
  

		  
    <td height="20"><?php if ($session->chkLevel(IS_ADMIN)):?>[<a href="index.php?<?php $glm->getQueryString();?>&action=overview"><?php echo TOTAL_SUMMARY;?></a>] - <?php endif;?>[<a href="index.php?<?php $glm->getQueryString();?>&action=domain"><?php echo DOMAIN_SUMMARY;?></a>] - [<a href="index.php?<?php $glm->getQueryString();?>&action=plist"><?php echo P_WHITELIST;?></a>] - [<a href="index.php?<?php $glm->getQueryString();?>&action=list"><?php echo WHITELIST;?></a>]<?php if ($session->chkLevel(IS_ADMIN)):?> - [<a href="index.php?<?php $glm->getQueryString();?>&action=admin"><?php echo GLM_ADMIN_PAGE;?></a>]<?php endif;?></td>
  </tr>
  <tr align="center" valign="middle"> 
    <td height="5"></td>
  </tr>
  <tr align="center" valign="middle" bgcolor="#000000"> 
    <td height="1"></td>
  </tr>
  <tr align="center" valign="middle"> 
    <td height="5"></td>
  </tr>
  <tr align="center" valign="top"> 
    <td><br>
    <?php 
     if(!stristr($erg = $glm->checkGLMPermissions(),".php")){
        echo $erg;
     }else{
       include($erg);
     }

    ?>
</td>
  </tr>
  <tr align="center" valign="middle"> 
    <td height="5"></td>
  </tr>
  <tr align="center" valign="middle" bgcolor="#000000"> 
    <td height="1"></td>
  </tr>
  <tr align="center" valign="middle"> 
    <td height="5"></td>
  </tr>

  <tr align="center" valign="middle"> 
    <td height="5">&copy; 2009-2012 <a href="http://www.haggybear.de">Matthias Hackbarth</a></td>
  </tr>
</table>
</body>
</html>
