<?php
/*
Plesk Greylisting Manager (Version see version.php) - GUI for Plesk greylisting implementation by Parallels

Copyright (C) [2009] [Matthias Hackbarth / www.haggybear.de]

This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as 
published by the Free Software Foundation; either version 3 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty 
of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program; if not, see <http://www.gnu.org/licenses/>.
*/

if(function_exists("apc_clear_cache")) @apc_clear_cache();

@session_start();

include("./config.inc.php");
include("./version.php");
include("./lang/".LANG.".inc.php");
include("./glm.class.php");
$glm = new glm(@$session,$_GET,array(DB_HOST,DB_NAME,DB_USR,DB_PWD));

$glm->setQueryString($_SERVER["QUERY_STRING"]);
$glm->readAbuseSettings();
$glm->readRemoteSettings();
$glm->getUserLists();

if(@$_POST["export"] == "1"){
  $glm->greylistingProps($_POST);
  $glm->doExport();
  }
?>
<html>
<head>
<title>Greylisting Stats</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<script language="javascript" type="text/javascript" src="/javascript/common.js"></script>
<script language="javascript" type="text/javascript" src="/javascript/chk.js.php"></script>
<script language="javascript" type="text/javascript" src="js/jquery-1.7.1.min.js"></script>
<script language="javascript" type="text/javascript" src="js/jquery.easyui.min.js"></script>
<script language="javascript" type="text/javascript" src="js/jquery.flot.js"></script>
<script language="javascript" type="text/javascript" src="js/jquery.flot.pie.js"></script>
<!--[if IE]><script language="javascript" type="text/javascript" src="js/excanvas.min.js"></script><![endif]-->
<script language="javascript" type="text/javascript" src="lang/easyui-lang-<?php echo LANG;?>.js"></script>
<script language="javascript" type="text/javascript" src="js/dateformat.js"></script>
<?php if(PSA_VERSION < 10):?>
<link rel="stylesheet" type="text/css" href="/skins/<?php echo $glm->getPleskSkin();?>/css/general.css">
<link rel="stylesheet" type="text/css" href="/skins/<?php echo $glm->getPleskSkin();?>/css/main/custom.css">
<link rel="stylesheet" type="text/css" href="/skins/<?php echo $glm->getPleskSkin();?>/css/main/layout.css">
<link rel="stylesheet" type="text/nonsense" href="/skins/<?php echo $glm->getPleskSkin();?>/css/misc.css">
<?php elseif(PSA_VERSION < 11.5):?>
<link rel="stylesheet" href="/skins/<?php echo $glm->getPleskSkin();?>/css/btns.css" type="text/css" />
<link rel="stylesheet" href="/skins/<?php echo $glm->getPleskSkin();?>/css/customer/main.css" type="text/css" />
<link rel="stylesheet" href="/skins/<?php echo $glm->getPleskSkin();?>/css/customer/custom.css" type="text/css" />
<?php else:?>
<link rel="stylesheet" href="/<?php echo $glm->getPleskSkin();?>/css/common.css" type="text/css" />
<link rel="stylesheet" href="/<?php echo $glm->getPleskSkin();?>/css/main.css" type="text/css" />
<link rel="stylesheet" href="/<?php echo $glm->getPleskSkin();?>/css/main-buttons.css" type="text/css" />
<link rel="stylesheet" href="/<?php echo $glm->getPleskSkin();?>/css/custom.css" type="text/css" />
<?php endif;?>

<link rel="stylesheet" type="text/css" href="themes/default/easyui.css">
<link rel="stylesheet" type="text/css" href="themes/icon.css">
<link rel="stylesheet" type="text/css" href="themes/<?php echo (stristr($_SERVER["HTTP_USER_AGENT"],"msie"))?"doof":"schlau";?>_browser.css">
<style type="text/css">

table{
font-size:11px !important;
}

body{
overflow-x:hidden;
}

.fitem{
margin-bottom:5px;
}

.fitem label{
display:inline-block;
width:290px;
}

.fitem input{
height:22px;
}

#hl{
width:600px;
margin-left:10px;
padding-left:45px;
height:30px;
background-image:url(images/glmlogo.gif);
background-repeat:no-repeat;
}

#hl h1{
padding-top:10px;
}

</style>
<script type="text/javascript">
var tmpColor = "";
var onScrWin = null;
var selectedGrid = "";
var loadDefaultDate = true;
var selectedRowData = "";
var ministatsLoaded = false;
var updStep = 0;
var updErg = 0;

<?php if(PSA_VERSION < 10):?>
var opt_no_frames = false;
var opt_integrated_mode = false;
<?php endif;?>

var mailaliases = new Array("<?php echo @implode('","',$glm->mailaliases);?>");

function doCalcTime(){
         secs = document.settings_form.adm_expireInterval.value;
         rest = secs%(60*24);
         days = (secs-rest)/(60*24);
         backString = days+" <?php echo GLM_DAYS;?>";

         if(rest>0){
           backString+= ", "+rest+" <?php echo GLM_MINUTES;?>";
           }
          
        document.getElementById("calcTime").innerHTML = "("+backString+")";
}

function fullscreen(){
top.location = "/smb/web/view";

dieBreite = Math.round(screen.width/100*90);
dieHoehe = Math.round(screen.height/100*90);

startx = (screen.width - dieBreite)/2;
starty = (screen.height - dieHoehe)/2;


GlmFenster = window.open(self.location, "GLMWindow", "width="+dieBreite+",height="+dieHoehe+",screenX="+startx+",screenX="+starty+",scrollbars=yes");
GlmFenster.focus();
}

function doExport(){
	       document.exportform.action = 'index.php?<?php $glm->getQueryString();?>&action='+selectedGrid;
	       document.exportform.filter.value = $('#filterfeld-'+selectedGrid).combobox('getValue');
	       document.exportform.zeit.value = $('#zeitfeld-'+selectedGrid).combobox('getValue')
	       dg = $('#grid-'+selectedGrid).datagrid('options');
	       document.exportform.limit.value = dg.pageSize;
	       document.exportform.submit();
	       }

function formatDateTime(val,row){
	 if(isNaN(val)) return "";
         var theDate = new Date();
         theDate.setTime(val*1000);
         return theDate.format("<?php echo TIME_SCHEME;?>");
         }
         
function deleteEntries(type){
 	 var ids = [];
	 var rows = $('#grid-'+selectedGrid).datagrid('getSelections');
	 for(var i=0; i<rows.length; i++){
	     ids.push('"'+type+'":"true","kide_blfr_'+i+'":"'+rows[i].created+'#'+rows[i].fromIp+'"')
	     }
	 var postString = '{'+ids.join(",")+'}';
	 var postObj = jQuery.parseJSON(postString);

	 $('#grid-'+selectedGrid).datagrid('load',postObj); 
	 cleanRequestData();
  	 
	 }  
	 
function holeData(dat){

         var loadHint = "<?php echo CHECKING_DATA;?>";
         var strURL = 'ident.php?dieip='+dat.text;
         var winWidth = 450;
         var winHeight = 550;

         if(dat.id == "check_mail"){
            loadHint = "<?php echo CHECKING_EMAIL;?>";
            strURL = 'cm.php?addy='+dat.text;
            winWidth = 630;
            winHeight = 225;                        
            }
         if(dat.id.indexOf("check_analyze")>-1){
            var parts = dat.id.split("|");
            loadHint = "<?php GLM_MAIL_ANALYZE;?>";
            strURL = 'analyze.php?from='+parts[1]+'&to='+parts[2]+'&time='+parts[3]+'&type=<?php echo $glm->plesk_smtp_type;?>';
            winWidth = 700;
            winHeight = 325;            
         
            }
	
	$('#serverStat').window({  
           width:winWidth,  
           height:winHeight,
	   title:dat.text,
	   closed:true,
	   modal:true,
	   collapsible:false,
	   minimizable:false,
	   maximizable:false
          });
          
	 $('#serverStat').window('open');
	 $('#serverStat').html('<div style="width:380px;height:40px;margin-top:'+((winHeight/2)-40)+'px;margin-left:'+((winWidth/2)-190)+'px;text-align:center">'+loadHint+'<br><img src="images/loading.gif" width="220" height="19"></div>');
         <?php if($glm->plesk_session->chkLevel(IS_ADMIN)):?>
         strURL+="&abuse=<?php echo $glm->glmSettings["abuse"]["enabled"];?>";
         <?php endif;?>
	 $('#serverStat').load(strURL);
        }	  
	 
function loadStats(w){
	 $('#serverStat').window({  
           width:450,  
           height:450,
	   title:'<?php echo SPAM_RATE.' '.SERVER_STAT;?>',
	   closed:true,
	   modal:true,
	   collapsible:false,
	   minimizable:false,
	   maximizable:false
          });
	 $('#serverStat').window('open');
         $('#serverStat').html('<div style="width:380px;height:40px;margin-top:205px;margin-left:45px;text-align:center"><?php echo GLM_GENERATATE_STATS;?><br><img src="images/loading.gif" width="220" height="19"></div>');
          dieZeit = $('#zeitfeld-'+selectedGrid).combobox('getValue');
          $.getJSON('stat.php?<?php $glm->getQueryString();?>&action='+selectedGrid+'&zeit='+dieZeit, function(data) {
               $.plot($("#serverStat"), data, 
               {
                  series: {
                      pie: { 
                          show: true,
                          radius: 1,
                          label: {
                              show: true,
                              radius: 3/4,
                              formatter: function(label, series){
                                  return '<div style="font-size:8pt;text-align:center;padding:2px;color:white;">'+label+'<br/>'+Math.round(series.percent)+'%</div>';
                              },
                              background: { opacity: 0.5 }
                          }
                      }
                  },
                  legend: {
                      show: false
                  }
            });
          }); 
	       }      
         
function loadMiniStat(){
	 if(selectedGrid.indexOf("lists")>-1){
	    return;
	    }
	
	 if(ministatsLoaded){
	    $('#stat-'+selectedGrid).panel('refresh','session.php?type=ministats');	
	    }
	 
	
	 $('#stat-'+selectedGrid).panel({  
		                 href:'session.php?type=ministats',
                                 border:false,
                                 height:60,
                                 title:'<?php echo MAILS_TOTAL;?>', 
                                 iconCls:'icon-ip-info', 
                                 collapsible:true, 
                                 collapsed:false
                                 });
         ministatsLoaded = true;                                  	
         }

function cleanRequestData(){
	 $('#grid-'+selectedGrid).datagrid({
	   queryParams:''	
   });
	 }
	 
function loadTree(){
	 $('#tree-'+selectedGrid).tree({
	 	  checkbox:true,
		  onClick:function(node){
		  	if(node.id.indexOf("wl_")>-1 || node.id.indexOf("bl_")>-1 || selectedGrid=="lists-pers") return;
			$('#tree-'+selectedGrid).tree('beginEdit', node.target);
			},
		  onAfterEdit:function(node){
		  	updateLists();
		        },
		  onLoadSuccess:function(node,data){
		  	$('#tree-'+selectedGrid+'-load').fadeOut("fast",function(){
		  	  $('#tree-'+selectedGrid).fadeIn("fast");
		  	  loadMiniStat();
		  	  });
		  	
		  	
		    }
		});
	 }
 
function updateLists(){
	 var postArray = new Array();
	 nodes = $('#tree-'+selectedGrid).tree('getChecked');
	 $('#tree-'+selectedGrid).fadeOut("fast",function(){
		  $('#tree-'+selectedGrid+'-load').fadeIn("fast");
		 });
	 
	 for(var i=0; i<nodes.length; i++){
	     postArray.push('"'+nodes[i].id.replace(/\./,'--DOT--')+'":"'+nodes[i].text+'"');
	     }
	 var postString = '{'+postArray.join(",")+'}';
	 var postObj = jQuery.parseJSON(postString);
	 console.log(postObj);
	 $.post('json.php?<?php $glm->getQueryString();?>&action='+selectedGrid+'&type=delete'+selectedGrid, postObj, function(data) {
	 	$('#tree-'+selectedGrid).tree('reload');
	 	});
	 }
	 
function createPersListQuite(item){
	
	 itemStr = (item=="mail_to_wl")?"addwl":"addbl";
	 
	 postString = '{"'+itemStr+'":"true","mboxFull":"'+selectedRowData.toMail+'","entry":"'+selectedRowData.fromMail+'"}';
	 var postObj = jQuery.parseJSON(postString);
	 $('#grid-'+selectedGrid).datagrid('loading'); 
         $.post("json.php?<?php $glm->getQueryString();?>&action="+selectedGrid+"&type=newlists-pers",postObj, function(data) {
	   	daten = data.split("|");
		$('#tree-'+selectedGrid).tree('reload');
		$.messager.alert(daten[2],daten[1],daten[0]);
		loadMiniStat();
		$('#grid-'+selectedGrid).datagrid('loaded'); 
         	});
	 }	 
	 
function createPersLists(){
	
	       sel = $('#tree-'+selectedGrid).tree('getSelected');
	       if(sel == null || sel.id.indexOf("wl_") == -1 && sel.id.indexOf("bl_") == -1){
	       	  $.messager.alert('<?php echo UPDATE_GLM_NOK;?>','<?php echo CREATE_NEW_LISTS_ERR;?>','error');
	          return;
	          }
	          
	       
	       var promptTitel = "<?php echo P_WHITELIST_DIRECT;?>"; 
	       if(sel.id.indexOf("bl_")>-1) promptTitel = "<?php echo P_BLACKLIST_DIRECT;?>";
	       $.messager.prompt(promptTitel, '<?php echo CREATE_NEW_LISTS_SINGLE;?>', function(r){
		  if (r){
	             $('#tree-'+selectedGrid).fadeOut("fast",function(){
		       $('#tree-'+selectedGrid+'-load').fadeIn("fast");
		     });		  	
		     mboxStr = sel.id.substring(3);
		     addType = (sel.id.indexOf("wl_")>-1)?"addwl":"addbl";
		     postString = '{"'+addType+'":"true","mbox":"'+mboxStr+'","entry":"'+r+'"}';
		     var postObj = jQuery.parseJSON(postString);
		     console.log(postObj);
		     $.post("json.php?<?php $glm->getQueryString();?>&action="+selectedGrid+"&type=newlists-pers",postObj, function(data) {
		     	   daten = data.split("|");
		     	   $('#tree-'+selectedGrid).tree('reload');
		     	   $.messager.alert(daten[2],daten[1],daten[0]);
         	           });
		    }
		 });
	       }
	 
function createLists(){	 
 	 $('#neueLists').window('open');
         }
         
function createListsSave(){
	       $.post("json.php?<?php $glm->getQueryString();?>&action="+selectedGrid+"&type=newlists",{ black_new: $("#black_new").val(), white_new: $("#white_new").val() } ,            function(data) {
         	  	$('#tree-lists').fadeOut("fast",function(){
	               $('#tree-lists-load').fadeIn("fast",function(){
	               	 loadMiniStat();
	               	 $('#tree-'+selectedGrid).tree('reload');
	               	 $("#white_new").val("");
	               	 $("#black_new").val("")
	               	 });
	              });
	       	
	       	if(data.indexOf("noinfo")>-1){
	       		 $('#neueLists').window('close');
	       		 return;
	       		 }
         	$.messager.alert('<?php echo UPDATE_GLM_OK;?>',data,'info',function(){$('#neueLists').window('close');});
         	  
            });
	       }

function loadGrid(){
	
	
	var TitleObj = [];
	TitleObj["domain"] = "<?php echo implode(", ",$glm->allDoms);?>";
	TitleObj["overview"] = "<?php echo MAILS_ALL;?>";
	
	$('#grid-'+selectedGrid).datagrid({
		url:"json.php?<?php $glm->getQueryString();?>&action="+selectedGrid+"&type=listentries",
		title:TitleObj[selectedGrid], 
		rownumbers:false,
 	        remoteSort:false,
                border:false,
 	        fitColumns:true,
 		pageList:[10,25,50,100,200,500],
 		pageSize:<?php echo PAGE_ENTRIES;?>, 			       
 	        pagination:true,
 	        columns:[[
                        {field:'fromIp',title:'<?php echo FROM_IP;?>',width:120,sortable:true},  
                        {field:'fromMail',title:'<?php echo FROM_MAIL;?>',width:270,sortable:true},
                        {field:'toMail',title:'<?php echo TO_MAIL;?>',width:270,sortable:true},
                        {field:'blocked',title:'<?php echo BLOCKED;?>',width:70,sortable:true},
                        {field:'passed',title:'<?php echo PASSED;?>',width:70,sortable:true},
                        {field:'created',title:'<?php echo ENTRY_AT;?>',width:130,sortable:true,formatter:formatDateTime},
                        {field:'update',title:'<?php echo LAST_UPDATE;?>',width:130,sortable:true,formatter:formatDateTime},
                        {field:'expires',title:'<?php echo EXPIRES;?>',width:130,sortable:true,formatter:formatDateTime}                                                                                   ]],
		rowStyler:function(index,row){
			        rowColor = 'font-weight: bold; color: #CC0000';
					    if (row.passed>0) rowColor = 'font-weight: bold; color: #009900';
					    return rowColor;   					    
				      },
		onLoadSuccess:function(){
			        loadMiniStat();
			        if(loadDefaultDate){
			           $('#zeitfeld-'+selectedGrid).combobox({
 				           url:'session.php?type=gldates',
 				           valueField:'id',
 				           textField:'text'
			            });
			          }
			        },
	 	onRowContextMenu: function(e, rowIndex, rowData){
					e.preventDefault();
					createColumnMenu(rowData,rowIndex);
					$('#context-menu_'+rowIndex+'_'+selectedGrid).menu('show', {
						left:e.pageX,
						top:e.pageY
					});
				}
	  });	
	  var pager = $('#grid-'+selectedGrid).datagrid('getPager');	
          pager.pagination({
                onBeforeRefresh:function(){
		                $('#grid-'+selectedGrid).datagrid('reload',{'query':''});  
		                 },
		buttons:[{
  	                 iconCls:'icon-search',
                         handler:function(){
                         $('#d2').window('open');	
                         $('#ss').searchbox({  
                                  width:'150px',
                                  value: '',  
                                  searcher:function(value){  
                                           $('#grid-'+selectedGrid).datagrid('reload',{'query':value});  
                                           $('#d2').window('close');	
                                           },  
                                  prompt:''  
                                  }); 	        
		         }
		}]
	 });
    	 $('#zeitfeld-'+selectedGrid).combobox({  
                         onSelect:function(){
                         	  loadDefaultDate = false;
                       	  $('#grid-'+selectedGrid).datagrid('reload',{'zeit':$('#zeitfeld-'+selectedGrid).combobox('getValue')}); 
                         	  }  
         }); 
    	 $('#filterfeld-'+selectedGrid).combobox({  
                         onSelect:function(){
                         	  $('#grid-'+selectedGrid).datagrid('reload',{'filter':$('#filterfeld-'+selectedGrid).combobox('getValue')}); 
                         	  }  
         });                       

$('#isremoteaccess').combobox({  
                     onSelect:function(record){
                     	        $('#isremoteaccess').combobox({
                     	        	     url:'json.php?<?php $glm->getQueryString();?>&action='+selectedGrid+'&type=remoteaccess&isremoteaccess='+$('#isremoteaccess').combobox('getValue'),
				                             valueField:'id',
				                             textField:'text'
			                               });
                     }
    });

}

function createColumnMenu(rowData,rowIndex){
	 selectedRowData = rowData;
 	 var tmenu = $('<div id="context-menu_'+rowIndex+'_'+selectedGrid+'" style="width:230px;"></div>').appendTo('body');
 	 $('<div id="check_ip" iconCls="icon-tip"/>').html(rowData.fromIp).appendTo(tmenu);
 	 <?php if ($glm->plesk_session->chkLevel(IS_ADMIN)):?>
 	 $('<div id="ip_to_wl" iconCls="icon-list-white"/>').html(rowData.fromIp).appendTo(tmenu);
 	 $('<div id="ip_to_bl" iconCls="icon-list-black"/>').html(rowData.fromIp).appendTo(tmenu);
 	 <?php endif;?>
 	 $('<div id="check_mail" iconCls="icon-tip"/>').html(rowData.fromMail).appendTo(tmenu);
	 
	 if($.inArray( rowData.toMail, mailaliases ) == -1 ){
  	    $('<div id="mail_to_wl" iconCls="icon-list-white-pers"/>').html(rowData.fromMail).appendTo(tmenu);
 	    $('<div id="mail_to_bl" iconCls="icon-list-black-pers"/>').html(rowData.fromMail).appendTo(tmenu);
 	    }
 	else{
  	    $('<div id="alias_to_wl" style="text-decoration:line-through;color:#BBBBBB" iconCls="icon-list-white-pers"/>').html(rowData.fromMail).appendTo(tmenu);
 	    $('<div id="alias_to_bl" style="text-decoration:line-through;color:#BBBBBB" iconCls="icon-list-black-pers"/>').html(rowData.fromMail).appendTo(tmenu);
 	   }
 	
 	 $('<div id="check_analyze|'+rowData.fromMail+'|'+rowData.toMail+'|'+rowData.update+'" iconCls="icon-analyze" />').html('<?php echo GLM_MAIL_ANALYZE;?>').appendTo(tmenu);
 	 
 	 tmenu.menu({
		onClick: function(item){
			 if(item.id.indexOf("check_")>-1)holeData(item);
			 if(item.id.indexOf("ip_to_")>-1){
	        		if(item.id == "ip_to_wl") $("#white_new").val(item.text); 	
	        		if(item.id == "ip_to_bl") $("#black_new").val(item.text); 	 	
			    	createListsSave()
			    }
			 if(item.id.indexOf("mail_to_")>-1){
			    	createPersListQuite(item.id)
			    }			    
			 if(item.id.indexOf("alias_to_")>-1){
                            $.messager.alert('<?php echo GLM_NOT_POSSIBLE;?>','<?php echo GLM_NO_ALIAS_TO_PLIST;?>','error');
			    }			    

			 }
		});
}
<?php if ($glm->plesk_session->chkLevel(IS_ADMIN)):?>
function loadForm(){
	 
	 $.extend($.fn.validatebox.defaults.rules, {  
                  integer: {  
                  validator: function(value){  
                             return !isNaN(value);  
                             },  
                  message: '<?php echo GLM_ADMIN_JS_ONLY_NUM;?>'  
                  }  
         }); 
         
        $('#cc').combobox({  
           url:'combobox_data.json',  
           valueField:'id',  
           textField:'text'  
          }); 
          
          
        $('#spamabuseselect').combobox({  
           onSelect:function(record){
           	        if(record.value=="true"){
           	                 $('#sas').validatebox({required:true});
           	                 $('#sat').validatebox({required:true});
           	        	 $('#fitemgroup').slideDown('fast');
           	        	 
           	           } 
           	        else{
           	                 $('#sas').validatebox({required:false});
           	                 $('#sat').validatebox({required:false});
           	        	 $('#fitemgroup').slideUp('fast');
           	          }
           	        
           	        
           	        }  
          });
                   
        $('#id_penaltyEnabled').combobox({  
           onSelect:function(record){
           	        if(record.value=="true"){
           	        	 document.settings_form.adm_penaltyInterval.disabled=false;
           	        	 $('#adm_penaltyInterval_item').slideDown('fast');
           	           } 
           	        else{
           	        	 document.settings_form.adm_penaltyInterval.disabled=true;
           	        	 $('#adm_penaltyInterval_item').slideUp('fast');
           	          }
           	        
           	        
           	        }  
          });        
          doCalcTime();
          $('#setup_f').form({
	 	   url:'json.php?<?php $glm->getQueryString();?>&action=admin&type=admsave',
		   onSubmit:function(){
		  	    return $(this).form('validate');
		   },
		   success:function(data){
		   	   daten = data.split("|");
		   	   tokenStr = "";
		   	   if(daten[0].length>4)tokenStr = "&nbsp;(Supertoken: <b>"+daten[0]+"</b>)";
		   	   $("#supertoken").html(tokenStr);
			   $.messager.alert('Info', '<span class="pass"><?php echo GLM_ADMIN_SAVE." ".UPDATE_GLM_OK;?></span>', 'info');
			   top.document.getElementById("leftFrame").src = "/left.php3";
		   }
	  });  	  
	  
	 }
<?php endif;?>	 

function _body_onload(){
        loff();
        <?php if(PSA_VERSION < 10):?>
        SetContext('<?php echo GLM_ADMIN;?>');
        <?php endif;?>
        <?php if(PSA_VERSION >= 10 && @$_COOKIE["noFullScreen"]<>1):?>
        if(top.location != self.location){
        	window.setTimeout('$("#fullscreen").slideDown("slow")',1000);
          }
        <?php endif;?>
        $('#allTabs').tabs({ 
	              onSelect:function(){  
		               var pp = $('#allTabs').tabs('getSelected'); 
		               selectedGrid = (pp.panel('options').bodyCls);
		               loadDefaultDate = true;
		               ministatsLoaded = false;
		               
		               if(selectedGrid == "domain" || selectedGrid == "overview"){
		               	  loadGrid();
		               	  }
		               else if(selectedGrid == "lists" || selectedGrid == "lists-pers"){
		               	  loadTree();
		               	 }
		               else if(selectedGrid == "settings"){
		               	  loadForm();
		               	 }		               	 
		               
		               }
                      });
 <?php if($glm->plesk_session->chkLevel(IS_ADMIN) && AUTOUPDATE):?>
$("#updateCheck").click(function() {
	runUpdate();
});
<?php endif;?>
 }
			
function _body_onunload(){
        lon();
	}

function abuseReport(email){
         $.messager.confirm('<?php echo GLM_SPAM_ABUSE_REPORT;?>', '<?php echo GLM_SPAM_ABUSE_REPORT_DO;?>', function(r){
	     if (!r)return;
             ip = selectedRowData.fromIp;
             from = selectedRowData.fromMail;
             to = selectedRowData.toMail;
             create = formatDateTime(selectedRowData.created,0);
             $.post("json.php?<?php $glm->getQueryString(); ?>&action=abusemail",{rec:email, ip:ip, from: from, to: to, create: create }, function(data){
                    if(data.indexOf("emailwassend")>-1){
                       $.messager.confirm('<?php echo UPDATE_GLM_OK;?>', '<?php echo GLM_SPAM_ABUSE_REPORT_DO_OK;?>', function(r){	
                                 if (r)$('#serverStat').window('close');
                                 });
                       }
                    else{
                       $.messager.alert('<?php echo UPDATE_GLM_OK;?>','<?php echo GLM_SPAM_ABUSE_REPORT_DO_NOK;?>','error');
                       }
                  });
           });                  
         }
<?php if($glm->plesk_session->chkLevel(IS_ADMIN)):?>         
function runUpdate(){
	
	       ergs = new Array('<span class="block"><?php echo UPDATE_GLM_NOK;?></span>','<span class="pass"><?php echo UPDATE_GLM_OK;?></span>');
	       
	       tabs = new Array('DUMMY','#upd_down','#upd_conf','#upd_inst','#upd_done');
	       	       
	       if(updStep==0)$('#doUpdate').window('open');
	       updStep++;
	       
	       if(updStep>=5){
	       	  $.get('up.php?step='+updStep, function(data) {
	       	  	var ergStr = '<span class="block"><?php echo UPDATE_GLM_FAILED;?></span>';
              if(updErg==4) ergStr = '<span class="pass">'+data+'</span>';
              $('#updBut').linkbutton('enable');
              $('#updPanel').html(ergStr);
            });
            return;
	        }
	       
	       $.get('up.php?step='+updStep, function(data) {
	       	  if(data==1)updErg++;
	       	  $(tabs[updStep]).removeClass("pagination-loading");
	       	  $(tabs[updStep]).html(ergs[data]);
	       	  runUpdate();
            });
         }
<?php endif;?>	      
</script>
<?php if(USE_FLATTR):?>
<script type="text/javascript">
/* <![CDATA[ */
(function() {
var s = document.createElement('script'), t = document.getElementsByTagName('script')[0];

s.type = 'text/javascript';
s.async = true;
s.src = 'http://api.flattr.com/js/0.5.0/load.js?mode=auto';

t.parentNode.insertBefore(s, t);
})();
/* ]]> */
</script>	
<?php endif;?>	
</head>
<?php
if($erg = $glm->checkGLMPermissions()){
	  echo "<body style='padding:10px'>".$erg."</body></html>";
	  exit;
    }
?>

<body onLoad="_body_onload();" onUnload="_body_onunload();" id="mainCP">
	
<div id="d2" 
     class="easyui-dialog" 
     title="<?php echo SEARCH_ENTRY;?>" 
     style="width:160px;height:80px;padding:10px;overflow:hidden"
     closed="true" 
     modal="true" 
     resizable="false">
  <input id="ss"></input>
</div> 
<div id="neueLists"
     class="easyui-window" 
     iconCls="icon-lists"
     title="<?php echo CREATE_NEW_LISTS;?>" 
     style="width:425px;height:175px;padding:10px;overflow:hidden"
     closed="true" 
     modal="true" 
     collapsible="false"
	   minimizable="false"
	   maximizable="false"
     resizable="false">
     <div class="easyui-layout" fit="true">
	<div region="center" border="false" style="padding:10px;background:#fff;border:1px solid #ccc;">
	<div style="width:125px;float:left;height:25px;padding-top:5px"><?php echo WHITELIST_DIRECT;?>:</div>
	<div style="width:220px;float:left;height:30px"><input type="text" style="width:220px;height:22px" id="white_new" value="" class="combo"></div>
	<div style="width:125px;float:left;height:25px;padding-top:5px"><?php echo BLACKLIST_DIRECT;?>:</div>
	<div style="width:220px;float:left;height:30px"><input type="text" style="width:220px;height:22px" id="black_new" value="" class="combo"></div>
	</div>
	<div region="south" border="false" style="text-align:right;padding:5px 0;">
		<a class="easyui-linkbutton" iconCls="icon-ok" href="javascript:void(0)" onclick="createListsSave()"><?php echo GLM_ADMIN_SAVE;?></a>
	</div>
     </div>
</div>	
<?php if($glm->plesk_session->chkLevel(IS_ADMIN)):?>  
<div id="doUpdate"
     class="easyui-window" 
     iconCls="icon-refresh"
     title="<?php echo UPDATE_GLM;?>" 
     style="width:425px;height:210px;padding:10px;overflow:hidden"
     closed="true" 
     modal="true" 
     collapsible="false"
	   minimizable="false"
	   maximizable="false"
	   resizable="false">
     <div class="easyui-layout" fit="true">
	<div region="center" id="updPanel" border="false" style="padding:10px;background:#fff;border:1px solid #ccc;overflow:hidden">
	          <div class="fitem">
	           <label style="vertical-align:top;padding-top:4px;width:250px"><?php echo UPDATE_DOWN;?></label>
             <span id="upd_down" style="padding:4px;width:150px;line-height:22px" class="pagination-loading">&nbsp;&nbsp;&nbsp;&nbsp;</span> 
	          </div>
	          <div class="fitem">
	           <label style="vertical-align:top;width:250px"><?php echo UPDATE_CONFIG;?></label>
             <span id="upd_conf" style="padding:4px;width:150px;line-height:22px" class="pagination-loading">&nbsp;&nbsp;&nbsp;&nbsp;</span> 
	          </div>
	          <div class="fitem">
	           <label style="vertical-align:top;width:250px"><?php echo UPDATE_INSTALL;?></label>
             <span id="upd_inst" style="padding:4px;width:150px;line-height:22px" class="pagination-loading">&nbsp;&nbsp;&nbsp;&nbsp;</span> 
	          </div>
	          <div class="fitem">
	           <label style="vertical-align:top;width:250px"><?php echo UPDATE_DONE;?></label>
             <span id="upd_done" style="padding:4px;width:150px;line-height:22px" class="pagination-loading">&nbsp;&nbsp;&nbsp;&nbsp;</span> 
	          </div>
	</div>
	<div region="south" border="false" style="text-align:right;padding:5px 0;">
		<a class="easyui-linkbutton" id="updBut" disabled="true" iconCls="icon-ok" href="index.php?<?php $glm->getQueryString();?>">OK</a>
	</div>
     </div>
</div>
<?php endif;?>
						      
<?php if(PSA_VERSION < 10):?>	
    <div class="pathbar"><a href="/domains/domains.php3" onclick="lon();">Domains</a> &gt; <a href="/domains/dom_ctrl.php3" onclick="lon();"><?php echo $_GET["dom_name"];?></a> &gt;</div>
	<div class="screenTitle">
          <table cellspacing="0" width="100%">
          <tbody>
          <tr>
            <td class="title"><div class='titleContainer clear'><h1><?php echo GLM_ADMIN;?> Domain <span class="name"><?php echo $_GET["dom_name"];?></span></h1></div>
	    </td>
            <td class="toolbar">
	    <?php if(USE_FLATTR):?>
            <div style="float:left;padding-top:7px"><a class="FlattrButton" style="display:none;" rev="flattr;button:compact;" href="http://www.haggybear.de/en/greylisting-manager"></a></div>
	    <?php endif;?>
	    <div class="toolbarWrapper">
	    <div class="toolbarItems">
	    <table cellspacing="0">
	    <tr>  
	    <td><div class="toolbarBtn" id="bid-up-level"><A name="up_level" id="up_level" href="/domains/dom_ctrl.php3?previous_page=subdomains" onClick=";lon();"><span><?php echo GLM_LEVEL_UP;?></span></a></div></td></tr>
           </table>	
         </div>
       </div>	
    </td>
  </tr>
 </tbody>
 </table>
</div>	
<?php else:?>
<div id="fullscreen" style="text-align:center">
<img src="images/full_screen.png" align="absmiddle">&nbsp;<a href="#" onClick="fullscreen()"><?php echo TOGGLE_FULLSCREEN;?></a>&nbsp;<img src="images/full_screen.png" align="absmiddle">
<div title="<?php echo NO_FULLSCREEN;?>" alt="<?php echo NO_FULLSCREEN;?>" id="fullscreen_no" onClick="$('#fullscreen').slideUp('slow');document.cookie = 'noFullScreen=1';">X</div>
</div>
<?php endif;?>	
<div id="hl"><h1><?php echo GLM_ADMIN;?> <?php echo GLM_VERSION;?> &nbsp;&nbsp;[<?php $glm->checkVersion(GLM_VERSION);?>]</h1></div>
<div id="allTabs" class="easyui-tabs" style="margin:5px">
                <?php if($_GET["cl_id"]>0):?>
		<div title="<?php echo DOMAIN_SUMMARY;?>" iconCls="icon-domain" bodyCls="domain" style="padding:0px;">
  		<div id="stat-domain"></div>
		 <table iconCls="icon-domain" id="grid-domain" toolbar="#grid-domain-tb"></table>
        	 <div id="grid-domain-tb" style="padding:5px;height:auto">
                   <div>
        	    <a href="#" class="easyui-linkbutton" iconCls="icon-mark-all" plain="true" onclick="javascript:deleteEntries('but_kill')"><?php echo MARK_KILL;?></a>
        	    <a href="#" class="easyui-linkbutton" iconCls="icon-mark-pass" plain="true" onclick="javascript:deleteEntries('but_pass')"><?php echo MARK_PASS;?></a>
        	    <a href="#" class="easyui-linkbutton" iconCls="icon-mark-block" plain="true" onclick="javascript:deleteEntries('but_block')"><?php echo MARK_BLOCK;?></a>
        	    <a href="#" class="easyui-linkbutton" iconCls="icon-stats" plain="true" onclick="javascript:loadStats()"><?php echo SERVER_STAT;?></a>
        	    <a href="#" class="easyui-linkbutton" iconCls="icon-export" plain="true" onclick="javascript:doExport()"><?php echo CSV_EXPORT;?></a> 
        	   </div>
        	   <div>
        	    <?php echo SHOW_ENTRY;?>:  
                    <input class="easyui-combobox" id="zeitfeld-domain" name="zeit-domain" style="width:100px" panelHeight="auto">
                    <select name="filter-domain" id="filterfeld-domain" class="easyui-combobox" panelHeight="auto">
                      <option value="all"><?php echo SHOW_ALL;?></option>
                      <option value="pass"><?php echo SHOW_PASS;?></option>
                      <option value="block"><?php echo SHOW_BLOCK;?></option>
                     </select>
                     &nbsp;|&nbsp;<a href="http://www.haggybear.de/download/glm-remote-example.zip" alt="<?php echo GLM_REMOTE_ACCESS_EXAMPLE;?>" title="<?php echo GLM_REMOTE_ACCESS_EXAMPLE;?>"><?php echo GLM_REMOTE_ACCESS;?></a>
<?php $glm->checkForRemoteAccess();?>
        	   </div>
        	  </div>		 
                </div>
                <?php endif;?>
		<?php if ($glm->plesk_session->chkLevel(IS_ADMIN)):?>
		<div title="<?php echo TOTAL_SUMMARY;?>" iconCls="icon-sum" bodyCls="overview" style="padding:0px;">
		<div id="stat-overview"></div>
		 <table iconCls="icon-domain"  id="grid-overview" toolbar="#grid-overview-tb"></table>
        	 <div id="grid-overview-tb" style="padding:5px;height:auto">
                   <div>
        	    <a href="#" class="easyui-linkbutton" iconCls="icon-cancel" plain="true" onclick="javascript:deleteEntries('killall')"><?php echo KILL_TABLE;?></a>
        	    <a href="#" class="easyui-linkbutton" iconCls="icon-cleanup" plain="true" onclick="javascript:deleteEntries('cleanup')"><?php echo CRON_JOB;?></a>
        	    <a href="#" class="easyui-linkbutton" iconCls="icon-mark-all" plain="true" onclick="javascript:deleteEntries('but_kill')"><?php echo MARK_KILL;?></a>
        	    <a href="#" class="easyui-linkbutton" iconCls="icon-mark-pass" plain="true" onclick="javascript:deleteEntries('but_pass')"><?php echo MARK_PASS;?></a>
        	    <a href="#" class="easyui-linkbutton" iconCls="icon-mark-block" plain="true" onclick="javascript:deleteEntries('but_block')"><?php echo MARK_BLOCK;?></a>
        	    <a href="#" class="easyui-linkbutton" iconCls="icon-stats" plain="true" onclick="javascript:loadStats()"><?php echo SERVER_STAT;?></a>   
        	    <a href="#" class="easyui-linkbutton" iconCls="icon-export" plain="true" onclick="javascript:doExport()"><?php echo CSV_EXPORT;?></a>        	         	   
        	   </div>
        	   <div>
        	    <?php echo SHOW_ENTRY;?>:  
                    <input class="easyui-combobox" id="zeitfeld-overview" name="zeit-overview" style="width:100px" panelHeight="auto">
                    <select name="filter-overview" id="filterfeld-overview" class="easyui-combobox" panelHeight="auto">
                      <option value="all"><?php echo SHOW_ALL;?></option>
                      <option value="pass"><?php echo SHOW_PASS;?></option>
                      <option value="block"><?php echo SHOW_BLOCK;?></option>
                     </select>
        	   </div>

        	  </div>
 	        </div>
		<?php endif;?>
		<?php if($_GET["cl_id"]>0):?>
		<div id="tab-lists-pers" title="<?php echo P_WHITELIST;?>" iconCls="icon-lists-pers" bodyCls="lists-pers" style="overflow:hidden;padding:20px">
		<div style="padding:10px"><?php echo WHITELISTS_NOTICE_2;?></div>
                <div id="tree-lists-pers-container" style="width:65%;float:left">
                  <ul id="tree-lists-pers" iconCls="icon-lists-pers" url="json.php?<?php $glm->getQueryString();?>&action=plists&type=lists-pers" animate="true"></ul>
                  <div id="tree-lists-pers-load" class="pagination-loading" style="height:30px;margin:15px"></div>
                </div>
                <div id="tree-lists-pers-buttons" style="width:35%;float:left;text-align:left;margin-top:15px">
                  <a href="#" class="easyui-linkbutton" onclick="updateLists()" iconCls="icon-remove" style="margin-bottom:5px"><?php echo DELETE_OLD_PERSLISTS;?></a>&nbsp;
		  <a href="#" class="easyui-linkbutton" onclick="createPersLists()" iconCls="icon-add"><?php echo CREATE_NEW_LISTS;?></a>
                </div>  
		</div>
		<?php endif;?>
		<?php if ($glm->plesk_session->chkLevel(IS_ADMIN)):?>
 	        <div id="tab-lists" title="<?php echo WHITELIST;?>" iconCls="icon-lists" bodyCls="lists" style="padding:0px;">
                <div style="padding:10px"><?php echo WHITELISTS_NOTICE_1.WHITELISTS_NOTICE_2;?></div>
                <div id="tree-lists-container" style="width:50%;float:left">
                  <ul id="tree-lists" iconCls="icon-lists" url="json.php?<?php $glm->getQueryString();?>&action=lists&type=lists" animate="true"></ul>
                  <div id="tree-lists-load" class="pagination-loading" style="height:30px;margin:15px"></div>
                </div>
                <div id="tree-lists-buttons" style="width:50%;float:left;text-align:left;margin-top:15px">
                  <a href="#" class="easyui-linkbutton" iconCls="icon-remove" onclick="updateLists()" style="margin-bottom:5px"><?php echo DELETE_OLD_LISTS;?></a>&nbsp;
		  <a href="#" class="easyui-linkbutton" iconCls="icon-add" onclick="createLists()"><?php echo CREATE_NEW_LISTS;?></a>
                </div>                
		</div>
	        <div title="<?php echo GLM_ADMIN_PAGE;?>" iconCls="icon-settings" bodyCls="settings" style="padding:20px;">
                 <div id="form-settings-container" style="width:65%;float:left">
                 <form name="settings_form" id="setup_f" method="post" style="margin:5px">
	          <div class="fitem">
	           <label><?php echo GREYINTERVAL;?>:</label>
                   <input name="adm_greyInterval" style="width:75px" class="easyui-validatebox combo" value="<?php echo $glm->glmSettings["greyInterval"];?>" required="true" validType="integer"> <?php echo GLM_MINUTES;?>
	          </div>
	          <div class="fitem">
	           <label><?php echo EXPIREINTERVAL;?>:</label>
                   <input name="adm_expireInterval" class="easyui-validatebox combo" style="width:75px" required="true" value="<?php echo $glm->glmSettings["expireInterval"];?>" validType="integer" onKeyUp="doCalcTime()"> <?php echo GLM_MINUTES;?>&nbsp;&nbsp;<span style="font-size:9px;font-style:italic" id="calcTime"></span>
	          </div>
	          <div class="fitem">
	           <label><?php echo PENALTYENABLED;?>:</label>
  		   <select style="width:75px" name="adm_penaltyEnabled" id="id_penaltyEnabled" class="easyui-combobox" panelHeight="auto">
                    <option value="true" <?php echo ($glm->glmSettings["penaltyEnabled"]=="true")?"selected":"";?>><?php echo PENALTYENABLED_YES;?></option>
                    <option value="false" <?php echo ($glm->glmSettings["penaltyEnabled"]=="false")?"selected":"";?>><?php echo PENALTYENABLED_NO;?></option>
                   </select>
	          </div>
	          <div class="fitem" id="adm_penaltyInterval_item" style="display:<?php echo ($glm->glmSettings["penaltyEnabled"]=="false")?"none":"block";?>">
	           <label><?php echo PENALTYINTERVAL;?>:</label>
                   <input type="text" class="easyui-validatebox combo" name="adm_penaltyInterval" style="width:75px" <?php echo ($glm->glmSettings["penaltyEnabled"]=="false")?"disabled":"";?> value="<?php echo $glm->glmSettings["penaltyInterval"];?>" required="true" validType="integer"> <?php echo GLM_MINUTES;?>
	          </div>	          	          
	          <div class="fitem">
             <label><?php echo GLM_SPAM_REMOTE_ACCESS;?>:</label>
              <select name="remote-access[enabled]" class="easyui-combobox" panelHeight="auto" style="width:75px">
                 <option value="true" <?php echo ($glm->glmSettings["remote"]["enabled"]=="true")?"selected":"";?>><?php echo PENALTYENABLED_YES;?></option>
                 <option value="false" <?php echo ($glm->glmSettings["remote"]["enabled"]!="true")?"selected":"";?>><?php echo PENALTYENABLED_NO;?></option>
              </select>
	          </div>
	          <div class="fitem">
             <label><?php echo GLM_SPAM_PSA_INTEGRATION;?>:</label>
              <select name="psaIntegration" class="easyui-combobox" panelHeight="auto" style="width:75px">
                 <option value="true" <?php echo ($glm->glmSettings["psaIntegration"]=="true")?"selected":"";?>><?php echo PENALTYENABLED_YES;?></option>
                 <option value="false" <?php echo ($glm->glmSettings["psaIntegration"]!="true")?"selected":"";?>><?php echo PENALTYENABLED_NO;?></option>
              </select>
	          </div>

	          <div class="fitem">
             <label><?php echo GLM_SPAM_REMOTE_ACCESS_ADMIN;?>:</label>
              <select name="remote-access[admin]" class="easyui-combobox" panelHeight="auto" style="width:75px">
   <option value="true" <?php echo ($glm->glmSettings["remote"]["admin"]=="true")?"selected":"";?>><?php echo PENALTYENABLED_YES;?></option>
   <option value="false" <?php echo ($glm->glmSettings["remote"]["admin"]!="true")?"selected":"";?>><?php echo PENALTYENABLED_NO;?></option>
  </select><span id="supertoken"><?php if($glm->glmSettings["remote"]["admin"]=="true"):?>
  &nbsp;(Supertoken: <b><?php echo trim($glm->xtea->Decrypt($glm->glmSettings["remote"]["supertoken"]));?></b>)
  <?php endif;?></span>
	          </div>
	          <div class="fitem">
             <label><?php echo GLM_SPAM_ABUSE_REPORT;?>:</label>
               <select name="spam-abuse[enabled]" id="spamabuseselect" class="easyui-combobox" panelHeight="auto" style="width:75px">
   <option value="true" <?php echo ($glm->glmSettings["abuse"]["enabled"]=="true")?"selected":"";?>><?php echo PENALTYENABLED_YES;?></option>
   <option value="false" <?php echo ($glm->glmSettings["abuse"]["enabled"]!="true")?"selected":"";?>><?php echo PENALTYENABLED_NO;?></option>
  </select>
            </div>
	          	
	          <div id="fitemgroup"style="display:<?php echo ($glm->glmSettings["abuse"]["enabled"]=="true")?"block":"none";?>">
	          <div class="fitem">
	           <label><?php echo GLM_SPAM_ABUSE_REPORT_SENDER;?>:</label>
                   <input name="spam-abuse[sender]" id="sas" class="easyui-validatebox combo" style="width:175px" <?php echo ($glm->glmSettings["abuse"]["enabled"]=="true")?'required="true"':'';?> value="<?php echo ($glm->glmSettings["abuse"]["sender"]);?>">
	          </div>	
	          <div class="fitem">
	           <label><?php echo GLM_SPAM_ABUSE_REPORT_TITEL;?>:</label>
                   <input name="spam-abuse[titel]" id="sat" class="easyui-validatebox combo" style="width:175px" <?php echo ($glm->glmSettings["abuse"]["enabled"]=="true")?'required="true"':'';?> value="<?php echo ($glm->glmSettings["abuse"]["titel"]);?>">
	          </div>
	          <div class="fitem">
	           <label style="vertical-align:top"><?php echo GLM_SPAM_ABUSE_REPORT_TPL;?>:<br>{SPAMLINE} = <?php echo GLM_SPAM_ABUSE_REPORT_SPAMMAIL;?></label>
              <textarea name="spam-abuse[template]" cols="30" rows="10"><?php echo ($glm->glmSettings["abuse"]["template"]);?></textarea><br>
 
	          </div>
	          </div>	          
	         </form>
                 </div>
                 <div id="tree-lists-pers-buttons" style="width:35%;float:left;text-align:left;margin-top:15px">
                  <a href="#" class="easyui-linkbutton" iconCls="icon-save" onclick="$('#setup_f').submit();"><?php echo GLM_ADMIN_SAVE;?></a>
                </div>                   
                 </div>
		</div>
		<?php endif;?>
</div>
<table width="100%" cellpadding="0" cellspacing="0">
  </tr>
  <tr align="center" valign="middle"> 
    <td height="5"></td>
  </tr>
  <tr align="center" valign="middle" bgcolor="#000000"> 
    <td height="1"></td>
  </tr>
  <tr align="center" valign="middle"> 
    <td height="5"></td>
  </tr>

  <tr align="center" valign="middle"> 
    <td height="5">&copy; 2009-<?php echo date("Y");?> <a href="http://www.haggybear.de">Matthias Hackbarth</a></td>
  </tr>
</table>
<div id="serverStat" style="overflow-x:hidden"></div>
<form name="exportform" method="post">
	<input name="limit" type="hidden">
	<input name="filter" type="hidden">
	<input name="zeit" type="hidden">
	<input name="export" type="hidden" value="1">
</form>
</body>
</html>
